/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import java.nio.MappedByteBuffer;

public class DebugLineStrParser {
    MappedByteBuffer mapper = null;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;

    public DebugLineStrParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setSectionOffset(l);
        this.setSectionSize(l2);
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.mapper) {
            return;
        }
        this.mapper = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null == this.mapper) {
            this.mapper = FileHelper.mapSymtabIndexFile(this.fileName, this.sectionOffset, this.sectionSize);
            if (null == this.mapper) {
                return false;
            }
        }
        return true;
    }

    private String pickString(long l) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        while (0 != (by = this.mapper.get((int)(l + l2)))) {
            stringBuffer.append((char)by);
            ++l2;
        }
        return stringBuffer.toString();
    }

    public String getString(long l) {
        if (l < 0L || l >= this.sectionSize) {
            return null;
        }
        if (null == this.mapper && !this.openFile()) {
            return null;
        }
        String string = this.pickString(l);
        return string;
    }
}

