/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.Augmentation;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;

class CommonInformationEntry {
    Long offset;
    Long length;
    Format format;
    short version;
    Augmentation augmentation;
    short addressSize;
    short segmentSize;
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    Register returnAddressRegister;
    Reader initialInstructions;

    CommonInformationEntry(long l, long l2, Format format, short s2, Augmentation augmentation, short s3, short s4, long l3, long l4, Register register, Reader reader) {
        this.offset = l;
        this.length = l2;
        this.format = format;
        this.version = s2;
        this.augmentation = augmentation;
        this.addressSize = s3;
        this.segmentSize = s4;
        this.codeAlignmentFactor = l3;
        this.dataAlignmentFactor = l4;
        this.returnAddressRegister = register;
        this.initialInstructions = reader;
    }

    public CallFrameInstructionIter instructions(UnwindSection unwindSection, BaseAddresses baseAddresses) {
        return new CallFrameInstructionIter(this.initialInstructions._clone(), null, new PointerEncodingParameters(baseAddresses.ehFrame, null, this.addressSize, unwindSection.section()));
    }

    public static CommonInformationEntry parseRest(Long l, Long l2, Format format, BaseAddresses baseAddresses, _UnwindSectionPrivate _UnwindSectionPrivate2, Reader reader) {
        short s2 = reader.readU8();
        if (s2 != 1 && s2 != 3 && s2 != 4) {
            throw new RuntimeException("UnknownVersion:" + s2);
        }
        Reader reader2 = reader.readNullTerminatedSlice();
        short s3 = _UnwindSectionPrivate2.addressSize();
        short s4 = _UnwindSectionPrivate2.segmentSize();
        if (_UnwindSectionPrivate2.hasAddressAndSegmentSizes(s2)) {
            s3 = reader.readU8();
            s4 = reader.readU8();
        }
        long l3 = reader.readULeb128();
        long l4 = reader.readSLeb128();
        Register register = null;
        register = s2 == 1 ? new Register(reader.readU8()) : new Register((int)reader.readULeb128());
        Augmentation augmentation = null;
        if (!reader2.isEmpty()) {
            augmentation = Augmentation.parse(reader2, baseAddresses, s3, _UnwindSectionPrivate2, reader);
        }
        return new CommonInformationEntry(l, l2, format, s2, augmentation, s3, s4, l3, l4, register, reader);
    }
}

