/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.DwEhPe;
import com.uqm.crashsight.symtabtool.dwarf.Personality;
import com.uqm.crashsight.symtabtool.dwarf.Pointer;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;

class Augmentation {
    DwEhPe lsda;
    Personality personality;
    DwEhPe fdeAddressEncoding;
    boolean isSignalTrampoline;

    Augmentation() {
    }

    public static <R extends Reader> DwEhPe parsePointerEncoding(R r) {
        if (r == null) {
            Log.error("parsePointerEncoding input is null", new Object[0]);
            return null;
        }
        short s2 = r.readU8();
        DwEhPe dwEhPe = new DwEhPe(s2);
        if (dwEhPe.isValidEncoding()) {
            return dwEhPe;
        }
        throw new RuntimeException("UnknownPointerEncoding");
    }

    public static Pointer parseEncodedPointer(DwEhPe dwEhPe, PointerEncodingParameters pointerEncodingParameters, Reader reader) {
        long l;
        if (dwEhPe == null) {
            throw new RuntimeException("parseEncodedPointer encoding is null");
        }
        if (!dwEhPe.isValidEncoding()) {
            throw new RuntimeException("CannotParseOmitPointerEncoding");
        }
        if (dwEhPe.val == 255) {
            throw new RuntimeException("CannotParseOmitPointerEncoding");
        }
        int n = dwEhPe.application().val;
        switch (n) {
            case 0: {
                l = 0L;
                break;
            }
            case 16: {
                Long l2 = pointerEncodingParameters.bases.section;
                if (l2 != null) {
                    Long l3 = reader.offsetFrom(pointerEncodingParameters.section);
                    l = l2 + l3;
                    break;
                }
                throw new RuntimeException("PcRelativePointerButSectionBaseIsUndefined");
            }
            case 32: {
                if (pointerEncodingParameters.bases.text != null) {
                    l = pointerEncodingParameters.bases.text;
                    break;
                }
                Log.error("TextRelativePointerButTextBaseIsUndefined", new Object[0]);
                return null;
            }
            case 48: {
                if (pointerEncodingParameters.bases.data != null) {
                    l = pointerEncodingParameters.bases.data;
                    break;
                }
                Log.error("DataRelativePointerButDataBaseIsUndefined", new Object[0]);
                return null;
            }
            case 64: {
                if (pointerEncodingParameters.funcBase != null) {
                    l = pointerEncodingParameters.funcBase;
                    break;
                }
                Log.error("FuncRelativePointerInBadContext", new Object[0]);
                return null;
            }
            case 80: {
                Log.error("UnsupportedPointerEncoding", new Object[0]);
                return null;
            }
            default: {
                return null;
            }
        }
        long l4 = 0L;
        int n2 = dwEhPe.format().val;
        switch (n2) {
            case 0: {
                l4 = reader.readAddress(pointerEncodingParameters.addressSize);
                break;
            }
            case 1: {
                l4 = reader.readULeb128();
                break;
            }
            case 2: {
                l4 = reader.readU16();
                break;
            }
            case 3: {
                l4 = reader.readU32();
                break;
            }
            case 4: {
                l4 = reader.readU64();
                break;
            }
            case 9: {
                l4 = reader.readSLeb128();
                break;
            }
            case 10: {
                l4 = reader.readI16();
                break;
            }
            case 11: {
                l4 = reader.readI32();
                break;
            }
            case 12: {
                l4 = reader.readI64();
            }
        }
        return new Pointer(dwEhPe, l + l4);
    }

    public static <R extends Reader> Augmentation parse(Reader reader, BaseAddresses baseAddresses, short s2, _UnwindSectionPrivate _UnwindSectionPrivate2, Reader reader2) {
        Augmentation augmentation = new Augmentation();
        boolean bl = false;
        Reader reader3 = null;
        while (!reader.isEmpty()) {
            char c = (char)reader.readU8();
            switch (c) {
                case 'z': {
                    if (bl) {
                        throw new RuntimeException("UnknownAugmentation");
                    }
                    long l = reader2.readULeb128();
                    reader3 = reader2.split(l);
                    break;
                }
                case 'L': {
                    augmentation.lsda = Augmentation.parsePointerEncoding(reader3);
                    break;
                }
                case 'P': {
                    DwEhPe dwEhPe = Augmentation.parsePointerEncoding(reader3);
                    PointerEncodingParameters pointerEncodingParameters = new PointerEncodingParameters(baseAddresses.ehFrame, null, s2, _UnwindSectionPrivate2.section());
                    Pointer pointer = Augmentation.parseEncodedPointer(dwEhPe, pointerEncodingParameters, reader3);
                    augmentation.personality = new Personality(dwEhPe, pointer);
                    break;
                }
                case 'R': {
                    augmentation.fdeAddressEncoding = Augmentation.parsePointerEncoding(reader3);
                    break;
                }
                case 'S': {
                    augmentation.isSignalTrampoline = true;
                    break;
                }
                default: {
                    Log.error("UnknownAugmentation", new Object[0]);
                    return null;
                }
            }
            bl = true;
        }
        return augmentation;
    }
}

