/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.utils;

import java.util.HashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private final int capacity;
    private final Map<K, Node> cache;
    private final Node head;
    private final Node tail;

    public LRUCache(int n) {
        this.capacity = n;
        this.cache = new HashMap<K, Node>();
        this.head = new Node(null, null);
        this.head.next = this.tail = new Node(null, null);
        this.tail.prev = this.head;
    }

    public V get(K k) {
        Node node = this.cache.get(k);
        if (node == null) {
            return null;
        }
        this.moveToHead(node);
        return node.value;
    }

    public boolean containsKey(K k) {
        return this.cache.containsKey(k);
    }

    public void put(K k, V v) {
        Node node = this.cache.get(k);
        if (node != null) {
            node.value = v;
            this.moveToHead(node);
        } else {
            Node node2 = new Node(k, v);
            this.cache.put(k, node2);
            this.addToHead(node2);
            if (this.cache.size() > this.capacity) {
                Node node3 = this.removeTail();
                this.cache.remove(node3.key);
            }
        }
    }

    private void addToHead(Node node) {
        node.prev = this.head;
        node.next = this.head.next;
        this.head.next.prev = node;
        this.head.next = node;
    }

    private void moveToHead(Node node) {
        this.removeNode(node);
        this.addToHead(node);
    }

    private void removeNode(Node node) {
        node.prev.next = node.next;
        node.next.prev = node.prev;
    }

    private Node removeTail() {
        Node node = this.tail.prev;
        this.removeNode(node);
        return node;
    }

    public long getSize() {
        return this.cache.size();
    }

    private class Node {
        K key;
        V value;
        Node prev;
        Node next;

        Node(K k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

