/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.upload;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class HttpClientHelper {
    public static final int FILE_TYPE_TXT = 0;
    public static final int FILE_TYPE_ZIP = 1;
    private static final int MIN_NETWORK_TIMEOUT = 20000;
    private static int connection_timeout = 300000;
    private static int socket_timeout = 300000;

    public static void setNetworkTimeout(int n) {
        if (n <= 0) {
            Log.error("Timeout of network set is invalid: %d", n);
            return;
        }
        if (n < 20000) {
            Log.warn("Timeout of network should be at least: %d", 20000);
            socket_timeout = 20000;
            connection_timeout = 20000;
        } else {
            Log.info("Timeout of network is set to: %d", n);
            socket_timeout = n;
            connection_timeout = n;
        }
    }

    private static boolean isRedirect(int n) {
        return n == 301 || n == 302 || n == 303 || n == 307;
    }

    private static CloseableHttpClient getHttpClient() {
        try {
            SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, null, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            return HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory(sSLConnectionSocketFactory).build();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject post(String string, boolean bl, HttpEntity httpEntity) {
        Object object;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("result", false);
        CloseableHttpClient closeableHttpClient = bl ? HttpClientHelper.getHttpClient() : HttpClients.createSystem();
        HttpPost httpPost = new HttpPost(string);
        RequestConfig requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(socket_timeout).setConnectTimeout(connection_timeout).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (200 == n || 201 == n || 202 == n || 204 == n) {
                object = closeableHttpResponse.getEntity();
                if (object == null) {
                    jsonObject.addProperty("message", "Failed because HTTP entity from server is null.");
                    Log.error("Failed because HTTP entity from server is null.", new Object[0]);
                    JsonObject jsonObject2 = jsonObject;
                    return jsonObject2;
                }
                StringBuilder stringBuilder = new StringBuilder();
                InputStream inputStream2 = object.getContent();
                int n2 = -1;
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream2.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n2, "utf-8"));
                }
                Log.debug("Response message from server for uploading: %s", stringBuilder.toString());
                HttpResponseBean httpResponseBean = new HttpResponseBean();
                httpResponseBean.statusCode = n;
                httpResponseBean.responseMessage = stringBuilder.toString();
                Gson gson = new Gson();
                jsonObject.addProperty("result", true);
                jsonObject.addProperty("data", gson.toJson(httpResponseBean));
                JsonObject jsonObject3 = jsonObject;
                return jsonObject3;
            }
            if (HttpClientHelper.isRedirect(n)) {
                object = closeableHttpResponse.getFirstHeader("Location");
                if (object == null) {
                    jsonObject.addProperty("message", "Failed to location info of headers to redirect.");
                    Log.error("Failed to location info of headers to redirect.", new Object[0]);
                    JsonObject jsonObject4 = jsonObject;
                    return jsonObject4;
                }
                String string2 = object.getValue();
                Log.error("Connection is redirecting to %s.", string2);
                JsonObject jsonObject5 = HttpClientHelper.post(string2, bl, httpEntity);
                return jsonObject5;
            }
            jsonObject.addProperty("message", "Failed to execute POST");
            Log.error("Failed to execute POST for \"%s\"", closeableHttpResponse.getStatusLine());
            JsonObject jsonObject6 = jsonObject;
            return jsonObject6;
        }
        catch (Exception exception) {
            jsonObject.addProperty("result", false);
            jsonObject.addProperty("message", "Connection timed out! Please Check your network.");
            Log.error("Connection timed out! Please Check your network.", new Object[0]);
            object = jsonObject;
            return object;
        }
        finally {
            try {
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
    }

    private static HttpResponseBean get(String string, boolean bl) {
        CloseableHttpClient closeableHttpClient = bl ? HttpClientHelper.getHttpClient() : HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(string);
        RequestConfig requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(socket_timeout).setConnectTimeout(connection_timeout).build();
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (200 == n || 201 == n || 202 == n || 204 == n) {
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                HttpResponseBean httpResponseBean = new HttpResponseBean();
                httpResponseBean.statusCode = n;
                httpResponseBean.httpClient = closeableHttpClient;
                httpResponseBean.entity = httpEntity;
                return httpResponseBean;
            }
            if (HttpClientHelper.isRedirect(n)) {
                Header header = closeableHttpResponse.getFirstHeader("Location");
                if (header == null) {
                    Log.error("Failed to location info of headers to redirect.", new Object[0]);
                    return null;
                }
                String string2 = header.getValue();
                Log.error("Connection is redirecting to %s.", string2);
                return HttpClientHelper.get(string2, bl);
            }
            Log.error("Failed to execute POST for \"%s\"", closeableHttpResponse.getStatusLine());
            return null;
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            Log.error("Connection timed out! Please Check your network.", new Object[0]);
            return null;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Log.error("Socket timed out! Please Check your network.", new Object[0]);
            return null;
        }
        catch (ClientProtocolException clientProtocolException) {
            Log.error("Failed to execute GET!", new Object[0]);
            clientProtocolException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            Log.error("Failed to execute GET!", new Object[0]);
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadString(String string, boolean bl) {
        InputStream inputStream2 = null;
        HttpResponseBean httpResponseBean = HttpClientHelper.get(string, bl);
        if (null == httpResponseBean) {
            Log.error("Failed to download.", new Object[0]);
            return null;
        }
        String string2 = "";
        try {
            if (httpResponseBean.entity == null) {
                Log.error("Entity downloaded is null.", new Object[0]);
                String string3 = null;
                return string3;
            }
            inputStream2 = httpResponseBean.entity.getContent();
            int n = -1;
            byte[] byArray = new byte[1024];
            while ((n = inputStream2.read(byArray)) != -1) {
                string2 = string2 + new String(byArray, 0, n, "utf-8");
            }
            String string4 = string2;
            return string4;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            String string5 = null;
            return string5;
        }
        finally {
            try {
                if (null != inputStream2) {
                    inputStream2.close();
                }
                if (httpResponseBean.httpClient != null) {
                    httpResponseBean.httpClient.close();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String string, boolean bl, String string2) {
        Log.info("Downloading the file: " + string2, new Object[0]);
        InputStream inputStream2 = null;
        FileOutputStream fileOutputStream = null;
        HttpResponseBean httpResponseBean = HttpClientHelper.get(string, bl);
        if (null == httpResponseBean) {
            Log.error("Failed to download.", new Object[0]);
            return false;
        }
        try {
            if (httpResponseBean.entity == null) {
                Log.error("Entity downloaded is null.", new Object[0]);
                boolean bl2 = false;
                return bl2;
            }
            inputStream2 = httpResponseBean.entity.getContent();
            fileOutputStream = new FileOutputStream(new File(string2));
            int n = -1;
            byte[] byArray = new byte[1024];
            while ((n = inputStream2.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            Log.info("Successfully downloaded!", new Object[0]);
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (null != inputStream2) {
                    inputStream2.close();
                }
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                }
                if (httpResponseBean.httpClient != null) {
                    httpResponseBean.httpClient.close();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
    }

    public static JsonObject uploadFile(String string, boolean bl, File file, int n) {
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "text/plain";
                break;
            }
            case 1: {
                string2 = "application/zip";
                break;
            }
            default: {
                Log.error("File type is not acceptable", new Object[0]);
                return null;
            }
        }
        FileEntity fileEntity = new FileEntity(file, ContentType.create(string2, Consts.UTF_8));
        return HttpClientHelper.post(string, bl, fileEntity);
    }

    public static JsonObject uploadFile(String string, boolean bl, File file, int n, Map<String, String> map) {
        if (bl) {
            ContentType contentType;
            switch (n) {
                case 0: {
                    contentType = ContentType.TEXT_PLAIN;
                    break;
                }
                case 1: {
                    contentType = ContentType.APPLICATION_OCTET_STREAM;
                    break;
                }
                default: {
                    Log.error("File type is not acceptable", new Object[0]);
                    return null;
                }
            }
            FileBody fileBody = new FileBody(file, contentType);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("file", fileBody);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    Log.debug("key = %s, value = %s", entry.getKey(), entry.getValue());
                    StringBody stringBody = new StringBody(entry.getValue(), ContentType.TEXT_PLAIN);
                    multipartEntityBuilder.addPart(entry.getKey(), stringBody);
                }
            }
            Log.debug("url = %s", string);
            return HttpClientHelper.post(string, bl, multipartEntityBuilder.build());
        }
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "text/plain";
                break;
            }
            case 1: {
                string2 = "application/zip";
                break;
            }
            default: {
                Log.error("File type is not acceptable", new Object[0]);
                return null;
            }
        }
        FileEntity fileEntity = new FileEntity(file, string2);
        return HttpClientHelper.post(string, bl, fileEntity);
    }

    public static class HttpResponseBean {
        public CloseableHttpClient httpClient = null;
        public int statusCode;
        public String responseMessage = null;
        public HttpEntity entity = null;
    }
}

