/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common;

import com.uqm.crashsight.symtabtool.dwarf.DebugInfoPasrser;
import com.uqm.crashsight.symtabtool.symtab.Symbol;

public class Subroutine {
    private String name = null;
    private long lowPc = -1L;
    private long highPc = -1L;
    private int level = 0;
    private boolean symtab = false;
    private String filePathFromSymtab = null;
    public DebugInfoPasrser.DebugInfoEntry debugInfoEntry;

    public boolean beyond(long l) {
        return l < this.lowPc;
    }

    public boolean below(long l) {
        return l >= this.highPc;
    }

    public boolean contain(long l) {
        return l >= this.lowPc && l < this.highPc;
    }

    public boolean contain(Subroutine subroutine) {
        return subroutine.lowPc >= this.lowPc && subroutine.highPc <= this.highPc;
    }

    public boolean contain(Symbol symbol) {
        return symbol.getAddress() >= this.lowPc && symbol.getEndAddress() <= this.highPc;
    }

    public boolean contain(long l, long l2) {
        return l >= this.lowPc && l2 <= this.highPc;
    }

    public boolean equal(Subroutine subroutine) {
        return subroutine.lowPc == this.lowPc && subroutine.highPc == this.highPc;
    }

    public String toString() {
        return "Subroutine{name='" + this.name + '\'' + ", lowPc=0x" + Long.toHexString(this.lowPc) + ", highPc=0x" + Long.toHexString(this.highPc) + ", level=" + this.level + '}';
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String getName() {
        return this.name;
    }

    public long getLowPc() {
        return this.lowPc;
    }

    public long getHighPc() {
        return this.highPc;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSymtab() {
        return this.symtab;
    }

    public String getFilePathFromSymtab() {
        return this.filePathFromSymtab;
    }

    public DebugInfoPasrser.DebugInfoEntry getDebugInfoEntry() {
        return this.debugInfoEntry;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setLowPc(long l) {
        this.lowPc = l;
    }

    public void setHighPc(long l) {
        this.highPc = l;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setSymtab(boolean bl) {
        this.symtab = bl;
    }

    public void setFilePathFromSymtab(String string) {
        this.filePathFromSymtab = string;
    }

    public void setDebugInfoEntry(DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        this.debugInfoEntry = debugInfoEntry;
    }
}

