/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

public class SymtabIndexFileHeader {
    public static final int STIF_HEADER_LENGTH = 16;
    public static final int STIF_HEADER_LENGTH_V2 = 32;
    public static final int STIF_HEADER_LENGTH_V3 = 104;
    public static final int STIF_HEADER_LENGTH_V3_1 = 116;
    public static final int FORMAT_32 = 32;
    public static final int FORMAT_64 = 64;
    private static final int STIF_INDEX_ENTRY_LENGTH_32 = 12;
    private static final int STIF_INDEX_ENTRY_LENGTH_64 = 24;
    private int majorVersion = 3;
    private int minorVersion = 2;
    private int format = 32;
    private long symtabEntryNum = 0L;
    private long loadPvaddr = 0L;
    private long loadPoffset = 0L;
    private long align = 0L;
    private int hasDwarfInfo = 0;
    private long minEntryStartAddress = 0L;
    private long maxEntryEndAddress = 0L;
    private long maxEntryAddressSize = 0L;
    private long indexOffset = 0L;
    private long indexSize = 0L;
    private long offsetOffset = 0L;
    private long offsetSize = 0L;
    private long strOffset = 0L;
    private long strSize = 0L;

    public int getHeaderLength() {
        if (this.majorVersion == 2) {
            return 32;
        }
        if (this.majorVersion == 3) {
            if (this.minorVersion == 1) {
                return 116;
            }
            return 104;
        }
        return 16;
    }

    public String toString() {
        return String.format("majorVersion=%d,minorVersion=%d,format=%d,symtabEntryNum=%d,loadPvaddr=0x%x,loadPoffset=0x%x,hasDwarfInfo=0x%x,align=0x%x,minEntryStartAddress=0x%x,maxEntryEndAddress=0x%x,maxEntryAddressSize=0x%x,indexOffset=0x%x,indexSize=0x%x,offsetOffset=0x%x,offsetSize=0x%x,strOffset=0x%x,strSize=0x%x", this.majorVersion, this.minorVersion, this.format, this.symtabEntryNum, this.loadPvaddr, this.loadPoffset, this.hasDwarfInfo, this.align, this.minEntryStartAddress, this.maxEntryEndAddress, this.maxEntryAddressSize, this.indexOffset, this.indexSize, this.offsetOffset, this.offsetSize, this.strOffset, this.strSize);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFormat() {
        return this.format;
    }

    public long getSymtabEntryNum() {
        return this.symtabEntryNum;
    }

    public long getLoadPvaddr() {
        return this.loadPvaddr;
    }

    public long getLoadPoffset() {
        return this.loadPoffset;
    }

    public long getAlign() {
        return this.align;
    }

    public int getHasDwarfInfo() {
        return this.hasDwarfInfo;
    }

    public long getMinEntryStartAddress() {
        return this.minEntryStartAddress;
    }

    public long getMaxEntryEndAddress() {
        return this.maxEntryEndAddress;
    }

    public long getMaxEntryAddressSize() {
        return this.maxEntryAddressSize;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public long getIndexSize() {
        return this.indexSize;
    }

    public long getOffsetOffset() {
        return this.offsetOffset;
    }

    public long getOffsetSize() {
        return this.offsetSize;
    }

    public long getStrOffset() {
        return this.strOffset;
    }

    public long getStrSize() {
        return this.strSize;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public void setSymtabEntryNum(long l) {
        this.symtabEntryNum = l;
    }

    public void setLoadPvaddr(long l) {
        this.loadPvaddr = l;
    }

    public void setLoadPoffset(long l) {
        this.loadPoffset = l;
    }

    public void setAlign(long l) {
        this.align = l;
    }

    public void setHasDwarfInfo(int n) {
        this.hasDwarfInfo = n;
    }

    public void setMinEntryStartAddress(long l) {
        this.minEntryStartAddress = l;
    }

    public void setMaxEntryEndAddress(long l) {
        this.maxEntryEndAddress = l;
    }

    public void setMaxEntryAddressSize(long l) {
        this.maxEntryAddressSize = l;
    }

    public void setIndexOffset(long l) {
        this.indexOffset = l;
    }

    public void setIndexSize(long l) {
        this.indexSize = l;
    }

    public void setOffsetOffset(long l) {
        this.offsetOffset = l;
    }

    public void setOffsetSize(long l) {
        this.offsetSize = l;
    }

    public void setStrOffset(long l) {
        this.strOffset = l;
    }

    public void setStrSize(long l) {
        this.strSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SymtabIndexFileHeader)) {
            return false;
        }
        SymtabIndexFileHeader symtabIndexFileHeader = (SymtabIndexFileHeader)object;
        if (!symtabIndexFileHeader.canEqual(this)) {
            return false;
        }
        if (this.getMajorVersion() != symtabIndexFileHeader.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != symtabIndexFileHeader.getMinorVersion()) {
            return false;
        }
        if (this.getFormat() != symtabIndexFileHeader.getFormat()) {
            return false;
        }
        if (this.getSymtabEntryNum() != symtabIndexFileHeader.getSymtabEntryNum()) {
            return false;
        }
        if (this.getLoadPvaddr() != symtabIndexFileHeader.getLoadPvaddr()) {
            return false;
        }
        if (this.getLoadPoffset() != symtabIndexFileHeader.getLoadPoffset()) {
            return false;
        }
        if (this.getAlign() != symtabIndexFileHeader.getAlign()) {
            return false;
        }
        if (this.getHasDwarfInfo() != symtabIndexFileHeader.getHasDwarfInfo()) {
            return false;
        }
        if (this.getMinEntryStartAddress() != symtabIndexFileHeader.getMinEntryStartAddress()) {
            return false;
        }
        if (this.getMaxEntryEndAddress() != symtabIndexFileHeader.getMaxEntryEndAddress()) {
            return false;
        }
        if (this.getMaxEntryAddressSize() != symtabIndexFileHeader.getMaxEntryAddressSize()) {
            return false;
        }
        if (this.getIndexOffset() != symtabIndexFileHeader.getIndexOffset()) {
            return false;
        }
        if (this.getIndexSize() != symtabIndexFileHeader.getIndexSize()) {
            return false;
        }
        if (this.getOffsetOffset() != symtabIndexFileHeader.getOffsetOffset()) {
            return false;
        }
        if (this.getOffsetSize() != symtabIndexFileHeader.getOffsetSize()) {
            return false;
        }
        if (this.getStrOffset() != symtabIndexFileHeader.getStrOffset()) {
            return false;
        }
        return this.getStrSize() == symtabIndexFileHeader.getStrSize();
    }

    protected boolean canEqual(Object object) {
        return object instanceof SymtabIndexFileHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getMajorVersion();
        n2 = n2 * 59 + this.getMinorVersion();
        n2 = n2 * 59 + this.getFormat();
        long l = this.getSymtabEntryNum();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getLoadPvaddr();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getLoadPoffset();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getAlign();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        n2 = n2 * 59 + this.getHasDwarfInfo();
        long l5 = this.getMinEntryStartAddress();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getMaxEntryEndAddress();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getMaxEntryAddressSize();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = this.getIndexOffset();
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = this.getIndexSize();
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = this.getOffsetOffset();
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        long l11 = this.getOffsetSize();
        n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
        long l12 = this.getStrOffset();
        n2 = n2 * 59 + (int)(l12 >>> 32 ^ l12);
        long l13 = this.getStrSize();
        n2 = n2 * 59 + (int)(l13 >>> 32 ^ l13);
        return n2;
    }
}

