/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.uqm.crashsight.symtabtool.common.utils.Log;

public class Symbol {
    private long address = -1L;
    private long endAddress = 0L;
    private String function = null;
    private String sourceFile = null;
    private long sourceline = -1L;
    private long sourceEndLine = -1L;
    private String inlineFunction = null;
    private String inlineSourceFile = null;
    private long inlineSourceLine = -1L;
    public static final String SEPARATOR = "\t";
    public static final String NO_FUNCTION = "NoFunction";

    public boolean isCompelte() {
        return null != this.function;
    }

    public long getAddress() {
        return this.address;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public String getFunction() {
        return this.function;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public long getSourceLine() {
        return this.sourceline;
    }

    public long getSourceEndLine() {
        return this.sourceEndLine;
    }

    public String getInlineFunction() {
        return this.inlineFunction;
    }

    public String getInlineSourceFile() {
        return this.inlineSourceFile;
    }

    public long getInlineSourceLine() {
        return this.inlineSourceLine;
    }

    public void setInlineFunction(String string) {
        this.inlineFunction = string;
    }

    public void setInlineSourceFile(String string) {
        this.inlineSourceFile = string;
    }

    public void setInlineSourceLine(long l) {
        this.inlineSourceLine = l;
    }

    public void setAddress(long l) {
        if (l == 51460L) {
            this.address = l;
        }
        this.address = l;
    }

    public void setEndAddress(long l) {
        this.endAddress = l;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
    }

    public void setSourceLine(long l) {
        this.sourceline = l;
    }

    public void setSourceEndLine(long l) {
        this.sourceEndLine = l;
    }

    public Symbol parseString(String string) {
        if (string.contains("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        }
        String[] stringArray = string.split(SEPARATOR);
        String[] stringArray2 = string.split(";");
        if (stringArray.length < 3) {
            Log.error("Failed to parse the string\uff1a%s", string);
            return null;
        }
        this.address = Long.parseLong(stringArray[0], 16);
        this.endAddress = Long.parseLong(stringArray[1], 16);
        this.function = stringArray[2];
        if (this.function.equals(NO_FUNCTION)) {
            this.function = "unknown";
        }
        if (stringArray.length > 3) {
            int n = stringArray[3].lastIndexOf(":");
            if (-1 == n) {
                Log.error("Failed to parse the string\uff1a%s", string);
                return null;
            }
            this.sourceFile = stringArray[3].substring(0, n);
            String[] stringArray3 = stringArray[3].substring(n + 1).split("-");
            if (stringArray3[0].isEmpty()) {
                this.sourceline = -1L * Long.parseLong(stringArray3[1]);
            } else {
                this.sourceline = Long.parseLong(stringArray3[0]);
                if (stringArray3.length > 1) {
                    this.sourceEndLine = Long.parseLong(stringArray3[1]);
                }
            }
            if (stringArray.length > 4) {
                this.inlineFunction = stringArray[4] + ";";
                for (int i = 1; i < stringArray2.length; ++i) {
                    this.inlineFunction = this.inlineFunction + stringArray2[i] + ";";
                }
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (-1L == this.address) {
            Log.error("The symbol has no address!", new Object[0]);
            return null;
        }
        stringBuilder.append(Long.toHexString(this.address));
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(Long.toHexString(this.endAddress));
        stringBuilder.append(SEPARATOR);
        if (null != this.function) {
            stringBuilder.append(this.function);
        } else {
            stringBuilder.append(NO_FUNCTION);
        }
        if (null != this.sourceFile) {
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.getSrcLineString());
            if (null != this.inlineFunction) {
                stringBuilder.append(SEPARATOR);
                stringBuilder.append(this.inlineFunction);
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getSrcLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.sourceFile) {
            stringBuilder.append(this.sourceFile);
            stringBuilder.append(":");
            stringBuilder.append(this.sourceline);
            if (-1L != this.sourceEndLine) {
                stringBuilder.append("-");
                stringBuilder.append(this.sourceEndLine);
            }
        }
        return stringBuilder.toString();
    }

    public String getLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sourceline);
        if (-1L != this.sourceEndLine) {
            stringBuilder.append("-");
            stringBuilder.append(this.sourceEndLine);
        }
        return stringBuilder.toString();
    }

    public boolean contain(Symbol symbol) {
        return symbol.address >= this.address && symbol.endAddress <= this.endAddress;
    }

    public boolean contain(long l) {
        return l >= this.address && l < this.endAddress;
    }

    public boolean equals(Symbol symbol) {
        if (symbol.address != symbol.address) {
            return false;
        }
        if (!symbol.sourceFile.equals(this.sourceFile)) {
            return false;
        }
        if (symbol.sourceline != this.sourceline) {
            return false;
        }
        return symbol.sourceEndLine == this.sourceEndLine;
    }
}

