/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser;

import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class SymtabFileInfoParser {
    public static final String FILE_KEY = "File";
    public static final String FORMAT_KEY = "Format";
    public static final String ARCH_KEY = "Arch";
    public static final String APP_ID_KEY = "AppID";
    public static final String APP_VERSION_KEY = "AppVer";
    public static final String SYMBOLS_KEY = "Symbols";
    public static final String TOOL_VERSION_KEY = "Tool Version";
    public static final String FILE_VERSION_KEY = "File Version";
    public static final String BUILT_TIME_KEY = "Built Time";
    public static final String UUID_KEY = "UUID";
    public static final String SHA1_KEY = "SHA-1";
    public static final String P_VADDR = "Program Virtual Address";
    public static final String P_OFFSET = "Program Offset";
    public static final String P_ALIGN = "Program Align";
    private static final String SYMTAB_LABEL = "Symbol table";
    private static final String SYMTAB_DECOLLATOR = "\t";
    private static final int SYMBOL_MIN_LENGTH = 6;
    private String fileName = null;
    private HashMap<String, String> symtabHeaderInfos = null;
    private long symbolNumbers = 0L;
    private int headerLineCount = 0;

    private SymtabFileInfoParser() {
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    public long getSymbolNumbers() {
        return this.symbolNumbers;
    }

    public int getHeaderInfoLineCount() {
        return this.headerLineCount;
    }

    public String getInfo(String string) {
        if (null == this.symtabHeaderInfos) {
            return null;
        }
        return this.symtabHeaderInfos.get(string);
    }

    private boolean validate() {
        return this.symtabHeaderInfos.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(String string) {
        if (null == string) {
            return false;
        }
        this.setFileName(string);
        BufferedReader bufferedReader = FileHelper.openFileReader(new File(string));
        if (null == bufferedReader) {
            return false;
        }
        this.symtabHeaderInfos = new HashMap();
        String string2 = null;
        try {
            while (null != (string2 = bufferedReader.readLine())) {
                if (string2.contains(SYMTAB_LABEL)) {
                    string2 = bufferedReader.readLine();
                    ++this.headerLineCount;
                    break;
                }
                String[] stringArray = string2.split(SYMTAB_DECOLLATOR);
                if (stringArray.length <= 1) {
                    boolean bl = false;
                    return bl;
                }
                if (stringArray.length > 2) break;
                String string3 = stringArray[0].substring(0, stringArray[0].length() - 1);
                this.symtabHeaderInfos.put(string3, stringArray[1]);
                ++this.headerLineCount;
            }
            boolean bl = this.validate();
            return bl;
        }
        catch (IOException iOException) {
            Log.error(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(bufferedReader);
        }
    }

    public static SymtabFileInfoParser create(String string) {
        SymtabFileInfoParser symtabFileInfoParser = new SymtabFileInfoParser();
        if (!string.endsWith(".symbol")) {
            Log.warn("Not a symbol file!", new Object[0]);
            return null;
        }
        Log.info("Begin to parse the file\uff1a%s", string);
        if (!symtabFileInfoParser.parse(string)) {
            Log.error("Failed to parse the file", new Object[0]);
            return null;
        }
        Log.info("Successfully parsed the file", new Object[0]);
        return symtabFileInfoParser;
    }
}

