/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class Sign {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    public static String sign(String string, String string2, String string3) throws TencentCloudSDKException {
        String string4 = null;
        try {
            Mac mac = Mac.getInstance(string3);
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(UTF8), mac.getAlgorithm());
            mac.init(secretKeySpec);
            byte[] byArray = mac.doFinal(string2.getBytes(UTF8));
            string4 = DatatypeConverter.printBase64Binary(byArray);
        }
        catch (Exception exception) {
            throw new TencentCloudSDKException(exception.getClass().getName() + "-" + exception.getMessage());
        }
        return string4;
    }

    public static String makeSignPlainText(TreeMap<String, String> treeMap, String string, String string2, String string3) {
        String string4 = "";
        string4 = string4 + string;
        string4 = string4 + string2;
        string4 = string4 + string3;
        string4 = string4 + Sign.buildParamStr(treeMap, string);
        return string4;
    }

    protected static String buildParamStr(TreeMap<String, String> treeMap, String string) {
        String string2 = "";
        for (String string3 : treeMap.keySet()) {
            String string4 = treeMap.get(string3).toString();
            string2 = string2.length() == 0 ? string2 + '?' : string2 + '&';
            string2 = string2 + string3.replace("_", ".") + '=' + string4;
        }
        return string2;
    }

    public static String sha256Hex(String string) throws TencentCloudSDKException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TencentCloudSDKException("SHA-256 is not supported." + noSuchAlgorithmException.getMessage());
        }
        byte[] byArray = messageDigest.digest(string.getBytes(UTF8));
        return DatatypeConverter.printHexBinary(byArray).toLowerCase();
    }

    public static String sha256Hex(byte[] byArray) throws TencentCloudSDKException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TencentCloudSDKException("SHA-256 is not supported." + noSuchAlgorithmException.getMessage());
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return DatatypeConverter.printHexBinary(byArray2).toLowerCase();
    }

    public static byte[] hmac256(byte[] byArray, String string) throws TencentCloudSDKException {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TencentCloudSDKException("HmacSHA256 is not supported." + noSuchAlgorithmException.getMessage());
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, mac.getAlgorithm());
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new TencentCloudSDKException(invalidKeyException.getClass().getName() + "-" + invalidKeyException.getMessage());
        }
        return mac.doFinal(string.getBytes(UTF8));
    }
}

