/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.io;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.ConnectionSpecSelector;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.Version;
import com.squareup.okhttp.internal.framed.FramedConnection;
import com.squareup.okhttp.internal.http.Http1xStream;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.tls.CertificateChainCleaner;
import com.squareup.okhttp.internal.tls.OkHostnameVerifier;
import com.squareup.okhttp.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public final class RealConnection
implements Connection {
    private final Route route;
    private Socket rawSocket;
    public Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    public volatile FramedConnection framedConnection;
    public int streamCount;
    public BufferedSource source;
    public BufferedSink sink;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    public boolean noNewStreams;
    public long idleAtNanos = Long.MAX_VALUE;
    private static SSLSocketFactory lastSslSocketFactory;
    private static TrustRootIndex lastTrustRootIndex;

    public RealConnection(Route route) {
        this.route = route;
    }

    public void connect(int n, int n2, int n3, List<ConnectionSpec> list, boolean bl) throws RouteException {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(list);
        Proxy proxy = this.route.getProxy();
        Address address = this.route.getAddress();
        if (this.route.getAddress().getSslSocketFactory() == null && !list.contains(ConnectionSpec.CLEARTEXT)) {
            throw new RouteException(new UnknownServiceException("CLEARTEXT communication not supported: " + list));
        }
        while (this.protocol == null) {
            try {
                this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.getSocketFactory().createSocket() : new Socket(proxy);
                this.connectSocket(n, n2, n3, connectionSpecSelector);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.socket);
                Util.closeQuietly(this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                } else {
                    routeException.addConnectException(iOException);
                }
                if (bl && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
        }
    }

    private void connectSocket(int n, int n2, int n3, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        this.rawSocket.setSoTimeout(n2);
        try {
            Platform.get().connectSocket(this.rawSocket, this.route.getSocketAddress(), n);
        }
        catch (ConnectException connectException) {
            throw new ConnectException("Failed to connect to " + this.route.getSocketAddress());
        }
        this.source = Okio.buffer(Okio.source(this.rawSocket));
        this.sink = Okio.buffer(Okio.sink(this.rawSocket));
        if (this.route.getAddress().getSslSocketFactory() != null) {
            this.connectTls(n2, n3, connectionSpecSelector);
        } else {
            this.protocol = Protocol.HTTP_1_1;
            this.socket = this.rawSocket;
        }
        if (this.protocol == Protocol.SPDY_3 || this.protocol == Protocol.HTTP_2) {
            this.socket.setSoTimeout(0);
            FramedConnection framedConnection = new FramedConnection.Builder(true).socket(this.socket, this.route.getAddress().url().host(), this.source, this.sink).protocol(this.protocol).build();
            framedConnection.sendConnectionPreface();
            this.framedConnection = framedConnection;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectTls(int n, int n2, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        if (this.route.requiresTunnel()) {
            this.createTunnel(n, n2);
        }
        Address address = this.route.getAddress();
        SSLSocketFactory sSLSocketFactory = address.getSslSocketFactory();
        boolean bl = false;
        SSLSocket sSLSocket = null;
        try {
            TrustRootIndex trustRootIndex;
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.rawSocket, address.getUriHost(), address.getUriPort(), true);
            ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sSLSocket);
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.getUriHost(), address.getProtocols());
            }
            sSLSocket.startHandshake();
            Handshake handshake2 = Handshake.get(sSLSocket.getSession());
            if (!address.getHostnameVerifier().verify(address.getUriHost(), sSLSocket.getSession())) {
                X509Certificate x509Certificate = (X509Certificate)handshake2.peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.getUriHost() + " not verified:" + "\n    certificate: " + CertificatePinner.pin(x509Certificate) + "\n    DN: " + x509Certificate.getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames(x509Certificate));
            }
            if (address.getCertificatePinner() != CertificatePinner.DEFAULT) {
                trustRootIndex = RealConnection.trustRootIndex(address.getSslSocketFactory());
                List<Certificate> list = new CertificateChainCleaner(trustRootIndex).clean(handshake2.peerCertificates());
                address.getCertificatePinner().check(address.getUriHost(), list);
            }
            trustRootIndex = connectionSpec.supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.socket = sSLSocket;
            this.source = Okio.buffer(Okio.source(this.socket));
            this.sink = Okio.buffer(Okio.sink(this.socket));
            this.handshake = handshake2;
            this.protocol = trustRootIndex != null ? Protocol.get((String)((Object)trustRootIndex)) : Protocol.HTTP_1_1;
            bl = true;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            if (bl) return;
        }
        catch (AssertionError assertionError) {
            try {
                if (!Util.isAndroidGetsocknameError(assertionError)) throw assertionError;
                throw new IOException((Throwable)((Object)assertionError));
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                if (bl) throw throwable;
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
        Util.closeQuietly(sSLSocket);
        return;
    }

    private static synchronized TrustRootIndex trustRootIndex(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory != lastSslSocketFactory) {
            X509TrustManager x509TrustManager = Platform.get().trustManager(sSLSocketFactory);
            lastTrustRootIndex = Platform.get().trustRootIndex(x509TrustManager);
            lastSslSocketFactory = sSLSocketFactory;
        }
        return lastTrustRootIndex;
    }

    private void createTunnel(int n, int n2) throws IOException {
        Response response;
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.httpUrl();
        String string = "CONNECT " + httpUrl.host() + ":" + httpUrl.port() + " HTTP/1.1";
        block4: while (true) {
            Http1xStream http1xStream = new Http1xStream(null, this.source, this.sink);
            this.source.timeout().timeout(n, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout(n2, TimeUnit.MILLISECONDS);
            http1xStream.writeRequest(request.headers(), string);
            http1xStream.finishRequest();
            response = http1xStream.readResponse().request(request).build();
            long l = OkHeaders.contentLength(response);
            if (l == -1L) {
                l = 0L;
            }
            Source source2 = http1xStream.newFixedLengthSource(l);
            Util.skipAll(source2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            source2.close();
            switch (response.code()) {
                case 200: {
                    if (!this.source.buffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return;
                }
                case 407: {
                    request = OkHeaders.processAuthHeader(this.route.getAddress().getAuthenticator(), response, this.route.getProxy());
                    if (request != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() throws IOException {
        return new Request.Builder().url(this.route.getAddress().url()).header("Host", Util.hostHeader(this.route.getAddress().url())).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
    }

    boolean isConnected() {
        return this.protocol != null;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    public void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    public int allocationLimit() {
        FramedConnection framedConnection = this.framedConnection;
        return framedConnection != null ? framedConnection.maxConcurrentStreams() : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHealthy(boolean bl) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (this.framedConnection != null) {
            return true;
        }
        if (!bl) return true;
        try {
            int n = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (this.source.exhausted()) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            finally {
                this.socket.setSoTimeout(n);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Handshake getHandshake() {
        return this.handshake;
    }

    public boolean isMultiplexed() {
        return this.framedConnection != null;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol != null ? this.protocol : Protocol.HTTP_1_1;
    }

    public String toString() {
        return "Connection{" + this.route.getAddress().url().host() + ":" + this.route.getAddress().url().port() + ", proxy=" + this.route.getProxy() + " hostAddress=" + this.route.getSocketAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

