/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Http1xStream;
import com.squareup.okhttp.internal.http.Http2xStream;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.RouteSelector;
import com.squareup.okhttp.internal.io.RealConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okio.Sink;

public final class StreamAllocation {
    public final Address address;
    private final ConnectionPool connectionPool;
    private RouteSelector routeSelector;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpStream stream;

    public StreamAllocation(ConnectionPool connectionPool, Address address) {
        this.connectionPool = connectionPool;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpStream newStream(int n, int n2, int n3, boolean bl, boolean bl2) throws RouteException, IOException {
        try {
            HttpStream httpStream;
            RealConnection realConnection = this.findHealthyConnection(n, n2, n3, bl, bl2);
            if (realConnection.framedConnection != null) {
                httpStream = new Http2xStream(this, realConnection.framedConnection);
            } else {
                realConnection.getSocket().setSoTimeout(n2);
                realConnection.source.timeout().timeout(n2, TimeUnit.MILLISECONDS);
                realConnection.sink.timeout().timeout(n3, TimeUnit.MILLISECONDS);
                httpStream = new Http1xStream(this, realConnection.source, realConnection.sink);
            }
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                ++realConnection.streamCount;
                this.stream = httpStream;
                return httpStream;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int n, int n2, int n3, boolean bl, boolean bl2) throws IOException, RouteException {
        while (true) {
            RealConnection realConnection = this.findConnection(n, n2, n3, bl);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.streamCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) {
                return realConnection;
            }
            this.connectionFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int n, int n2, int n3, boolean bl) throws IOException, RouteException {
        Object object;
        RealConnection realConnection;
        Object object2 = this.connectionPool;
        synchronized (object2) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.stream != null) {
                throw new IllegalStateException("stream != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            realConnection = this.connection;
            if (realConnection != null && !realConnection.noNewStreams) {
                return realConnection;
            }
            object = Internal.instance.get(this.connectionPool, this.address, this);
            if (object != null) {
                this.connection = object;
                return object;
            }
            if (this.routeSelector == null) {
                this.routeSelector = new RouteSelector(this.address, this.routeDatabase());
            }
        }
        object2 = this.routeSelector.next();
        realConnection = new RealConnection((Route)object2);
        this.acquire(realConnection);
        object = this.connectionPool;
        synchronized (object) {
            Internal.instance.put(this.connectionPool, realConnection);
            this.connection = realConnection;
            if (this.canceled) {
                throw new IOException("Canceled");
            }
        }
        realConnection.connect(n, n2, n3, this.address.getConnectionSpecs(), bl);
        this.routeDatabase().connected(realConnection.getRoute());
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(HttpStream httpStream) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (httpStream == null || httpStream != this.stream) {
                throw new IllegalStateException("expected " + this.stream + " but was " + httpStream);
            }
        }
        this.deallocate(false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpStream stream() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.stream;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public synchronized RealConnection connection() {
        return this.connection;
    }

    public void release() {
        this.deallocate(false, true, false);
    }

    public void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate(boolean bl, boolean bl2, boolean bl3) {
        RealConnection realConnection = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (bl3) {
                this.stream = null;
            }
            if (bl2) {
                this.released = true;
            }
            if (this.connection != null) {
                if (bl) {
                    this.connection.noNewStreams = true;
                }
                if (this.stream == null && (this.released || this.connection.noNewStreams)) {
                    this.release(this.connection);
                    if (this.connection.streamCount > 0) {
                        this.routeSelector = null;
                    }
                    if (this.connection.allocations.isEmpty()) {
                        this.connection.idleAtNanos = System.nanoTime();
                        if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                            realConnection = this.connection;
                        }
                    }
                    this.connection = null;
                }
            }
        }
        if (realConnection != null) {
            Util.closeQuietly(realConnection.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection realConnection;
        HttpStream httpStream;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            httpStream = this.stream;
            realConnection = this.connection;
        }
        if (httpStream != null) {
            httpStream.cancel();
        } else if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionFailed(IOException iOException) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.routeSelector != null) {
                if (this.connection.streamCount == 0) {
                    Route route = this.connection.getRoute();
                    this.routeSelector.connectFailed(route, iOException);
                } else {
                    this.routeSelector = null;
                }
            }
        }
        this.connectionFailed();
    }

    public void connectionFailed() {
        this.deallocate(true, false, true);
    }

    public void acquire(RealConnection realConnection) {
        realConnection.allocations.add(new WeakReference<StreamAllocation>(this));
    }

    private void release(RealConnection realConnection) {
        int n = realConnection.allocations.size();
        for (int i = 0; i < n; ++i) {
            Reference<StreamAllocation> reference = realConnection.allocations.get(i);
            if (reference.get() != this) continue;
            realConnection.allocations.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public boolean recover(RouteException routeException) {
        if (this.connection != null) {
            this.connectionFailed(routeException.getLastConnectException());
        }
        return (this.routeSelector == null || this.routeSelector.hasNext()) && this.isRecoverable(routeException);
    }

    public boolean recover(IOException iOException, Sink sink2) {
        int n;
        if (this.connection != null) {
            n = this.connection.streamCount;
            this.connectionFailed(iOException);
            if (n == 1) {
                return false;
            }
        }
        int n2 = n = sink2 == null || sink2 instanceof RetryableSink ? 1 : 0;
        return (this.routeSelector == null || this.routeSelector.hasNext()) && this.isRecoverable(iOException) && n != 0;
    }

    private boolean isRecoverable(IOException iOException) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        return !(iOException instanceof InterruptedIOException);
    }

    private boolean isRecoverable(RouteException routeException) {
        IOException iOException = routeException.getLastConnectException();
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    public String toString() {
        return this.address.toString();
    }
}

