/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestLine;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.io.RealConnection;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http1xStream
implements HttpStream {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private final StreamAllocation streamAllocation;
    private final BufferedSource source;
    private final BufferedSink sink;
    private HttpEngine httpEngine;
    private int state = 0;

    public Http1xStream(StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    @Override
    public void setHttpEngine(HttpEngine httpEngine) {
        this.httpEngine = httpEngine;
    }

    @Override
    public Sink createRequestBody(Request request, long l) throws IOException {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l != -1L) {
            return this.newFixedLengthSink(l);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void cancel() {
        RealConnection realConnection = this.streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        this.httpEngine.writingRequestHeaders();
        String string = RequestLine.get(request, this.httpEngine.getConnection().getRoute().getProxy().type());
        this.writeRequest(request.headers(), string);
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return this.readResponse();
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        Source source2 = this.getTransferStream(response);
        return new RealResponseBody(response.headers(), Okio.buffer(source2));
    }

    private Source getTransferStream(Response response) throws IOException {
        if (!HttpEngine.hasBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.newChunkedSource(this.httpEngine);
        }
        long l = OkHeaders.contentLength(response);
        if (l != -1L) {
            return this.newFixedLengthSource(l);
        }
        return this.newUnknownLengthSource();
    }

    public boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    public void writeRequest(Headers headers, String string) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.sink.writeUtf8(string).writeUtf8("\r\n");
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    public Response.Builder readResponse() throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            Response.Builder builder;
            StatusLine statusLine;
            do {
                statusLine = StatusLine.parse(this.source.readUtf8LineStrict());
                builder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            } while (statusLine.code == 100);
            this.state = 4;
            return builder;
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException("unexpected end of stream on " + this.streamAllocation);
            iOException.initCause(eOFException);
            throw iOException;
        }
    }

    public Headers readHeaders() throws IOException {
        String string;
        Headers.Builder builder = new Headers.Builder();
        while ((string = this.source.readUtf8LineStrict()).length() != 0) {
            Internal.instance.addLenient(builder, string);
        }
        return builder.build();
    }

    public Sink newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new ChunkedSink();
    }

    public Sink newFixedLengthSink(long l) {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new FixedLengthSink(l);
    }

    @Override
    public void writeRequestBody(RetryableSink retryableSink) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 3;
        retryableSink.writeToSocket(this.sink);
    }

    public Source newFixedLengthSource(long l) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new FixedLengthSource(l);
    }

    public Source newChunkedSource(HttpEngine httpEngine) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new ChunkedSource(httpEngine);
    }

    public Source newUnknownLengthSource() throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        if (this.streamAllocation == null) {
            throw new IllegalStateException("streamAllocation == null");
        }
        this.state = 5;
        this.streamAllocation.noNewStreams();
        return new UnknownLengthSource();
    }

    private void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout2 = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout2.clearDeadline();
        timeout2.clearTimeout();
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        private UnknownLengthSource() {
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long l2 = Http1xStream.this.source.read(buffer, l);
            if (l2 == -1L) {
                this.inputExhausted = true;
                this.endOfInput();
                return -1L;
            }
            return l2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;
        private final HttpEngine httpEngine;

        ChunkedSource(HttpEngine httpEngine) throws IOException {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.httpEngine = httpEngine;
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            long l2;
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((l2 = Http1xStream.this.source.read(buffer, Math.min(l, this.bytesRemainingInChunk))) == -1L) {
                this.unexpectedEndOfInput();
                throw new ProtocolException("unexpected end of stream");
            }
            this.bytesRemainingInChunk -= l2;
            return l2;
        }

        private void readChunkSize() throws IOException {
            if (this.bytesRemainingInChunk != -1L) {
                Http1xStream.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1xStream.this.source.readHexadecimalUnsignedLong();
                String string = Http1xStream.this.source.readUtf8LineStrict().trim();
                if (this.bytesRemainingInChunk < 0L || !string.isEmpty() && !string.startsWith(";")) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + "\"");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException(numberFormatException.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                this.httpEngine.receiveHeaders(Http1xStream.this.readHeaders());
                this.endOfInput();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long l) throws IOException {
            this.bytesRemaining = l;
            if (this.bytesRemaining == 0L) {
                this.endOfInput();
            }
        }

        @Override
        public long read(Buffer buffer, long l) throws IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long l2 = Http1xStream.this.source.read(buffer, Math.min(this.bytesRemaining, l));
            if (l2 == -1L) {
                this.unexpectedEndOfInput();
                throw new ProtocolException("unexpected end of stream");
            }
            this.bytesRemaining -= l2;
            if (this.bytesRemaining == 0L) {
                this.endOfInput();
            }
            return l2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1xStream.this.source.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        protected final void endOfInput() throws IOException {
            if (Http1xStream.this.state != 5) {
                throw new IllegalStateException("state: " + Http1xStream.this.state);
            }
            Http1xStream.this.detachTimeout(this.timeout);
            Http1xStream.this.state = 6;
            if (Http1xStream.this.streamAllocation != null) {
                Http1xStream.this.streamAllocation.streamFinished(Http1xStream.this);
            }
        }

        protected final void unexpectedEndOfInput() {
            if (Http1xStream.this.state == 6) {
                return;
            }
            Http1xStream.this.state = 6;
            if (Http1xStream.this.streamAllocation != null) {
                Http1xStream.this.streamAllocation.noNewStreams();
                Http1xStream.this.streamAllocation.streamFinished(Http1xStream.this);
            }
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        private ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1xStream.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (l == 0L) {
                return;
            }
            Http1xStream.this.sink.writeHexadecimalUnsignedLong(l);
            Http1xStream.this.sink.writeUtf8("\r\n");
            Http1xStream.this.sink.write(buffer, l);
            Http1xStream.this.sink.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1xStream.this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1xStream.this.sink.writeUtf8("0\r\n\r\n");
            Http1xStream.this.detachTimeout(this.timeout);
            Http1xStream.this.state = 3;
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private long bytesRemaining;

        private FixedLengthSink(long l) {
            this.timeout = new ForwardingTimeout(Http1xStream.this.sink.timeout());
            this.bytesRemaining = l;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            Util.checkOffsetAndCount(buffer.size(), 0L, l);
            if (l > this.bytesRemaining) {
                throw new ProtocolException("expected " + this.bytesRemaining + " bytes but received " + l);
            }
            Http1xStream.this.sink.write(buffer, l);
            this.bytesRemaining -= l;
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1xStream.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining > 0L) {
                throw new ProtocolException("unexpected end of stream");
            }
            Http1xStream.this.detachTimeout(this.timeout);
            Http1xStream.this.state = 3;
        }
    }
}

