/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.FramedStream;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.Http2;
import com.squareup.okhttp.internal.framed.Ping;
import com.squareup.okhttp.internal.framed.PushObserver;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Spdy3;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class FramedConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp FramedConnection", true));
    final Protocol protocol;
    final boolean client;
    private final Listener listener;
    private final Map<Integer, FramedStream> streams = new HashMap<Integer, FramedStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    private final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    final Variant variant;
    final Socket socket;
    final FrameWriter frameWriter;
    final Reader readerRunnable;
    private final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    private FramedConnection(Builder builder) throws IOException {
        this.protocol = builder.protocol;
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client && this.protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        int n2 = this.nextPingId = builder.client ? 1 : 2;
        if (builder.client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostName = builder.hostName;
        if (this.protocol == Protocol.HTTP_2) {
            this.variant = new Http2();
            this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(String.format("OkHttp %s Push Observer", this.hostName), true));
            this.peerSettings.set(7, 0, 65535);
            this.peerSettings.set(5, 0, 16384);
        } else if (this.protocol == Protocol.SPDY_3) {
            this.variant = new Spdy3();
            this.pushExecutor = null;
        } else {
            throw new AssertionError((Object)this.protocol);
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.socket = builder.socket;
        this.frameWriter = this.variant.newWriter(builder.sink, this.client);
        this.readerRunnable = new Reader(this.variant.newReader(builder.source, this.client));
        new Thread(this.readerRunnable).start();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized FramedStream getStream(int n) {
        return this.streams.get(n);
    }

    synchronized FramedStream removeStream(int n) {
        FramedStream framedStream = this.streams.remove(n);
        if (framedStream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        this.notifyAll();
        return framedStream;
    }

    private synchronized void setIdle(boolean bl) {
        this.idleStartTimeNs = bl ? System.nanoTime() : Long.MAX_VALUE;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    public FramedStream pushStream(int n, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(n, list, bl, false);
    }

    public FramedStream newStream(List<Header> list, boolean bl, boolean bl2) throws IOException {
        return this.newStream(0, list, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FramedStream newStream(int n, List<Header> list, boolean bl, boolean bl2) throws IOException {
        FramedStream framedStream;
        boolean bl3 = !bl;
        boolean bl4 = !bl2;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int n2;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                n2 = this.nextStreamId;
                this.nextStreamId += 2;
                framedStream = new FramedStream(n2, this, bl3, bl4, list);
                if (framedStream.isOpen()) {
                    this.streams.put(n2, framedStream);
                    this.setIdle(false);
                }
            }
            if (n == 0) {
                this.frameWriter.synStream(bl3, bl4, n2, n, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.frameWriter.pushPromise(n, n2, list);
            }
        }
        if (!bl) {
            this.frameWriter.flush();
        }
        return framedStream;
    }

    void writeSynReply(int n, boolean bl, List<Header> list) throws IOException {
        this.frameWriter.synReply(bl, n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int n, boolean bl, Buffer buffer, long l) throws IOException {
        if (l == 0L) {
            this.frameWriter.data(bl, n, buffer, 0);
            return;
        }
        while (l > 0L) {
            int n2;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                n2 = (int)Math.min(l, this.bytesLeftInWriteWindow);
                n2 = Math.min(n2, this.frameWriter.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n2;
            }
            this.frameWriter.data(bl && (l -= (long)n2) == 0L, n, buffer, n2);
        }
    }

    void addBytesToWriteWindow(long l) {
        this.bytesLeftInWriteWindow += l;
        if (l > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int n, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostName, n}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.writeSynReset(n, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int n, ErrorCode errorCode) throws IOException {
        this.frameWriter.rstStream(n, errorCode);
    }

    void writeWindowUpdateLater(final int n, final long l) {
        executor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostName, n}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.frameWriter.windowUpdate(n, l);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int n;
        Ping ping = new Ping();
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            n = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(n, ping);
        }
        this.writePing(false, n, 1330343787, ping);
        return ping;
    }

    private void writePingLater(final boolean bl, final int n, final int n2, final Ping ping) {
        executor.execute(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostName, n, n2}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.writePing(bl, n, n2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean bl, int n, int n2, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(bl, n, n2);
        }
    }

    private synchronized Ping removePing(int n) {
        return this.pings != null ? this.pings.remove(n) : null;
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int n;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(n, errorCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode errorCode, ErrorCode errorCode2) throws IOException {
        assert (!Thread.holdsLock(this));
        IOException iOException = null;
        try {
            this.shutdown(errorCode);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        FramedStream[] framedStreamArray = null;
        Ping[] pingArray = null;
        FramedStream[] framedStreamArray2 = this;
        synchronized (this) {
            block19: {
                if (!this.streams.isEmpty()) {
                    framedStreamArray = this.streams.values().toArray(new FramedStream[this.streams.size()]);
                    this.streams.clear();
                    super.setIdle(false);
                }
                if (this.pings != null) {
                    pingArray = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
                // ** MonitorExit[framedStreamArray2] (shouldn't be in output)
                if (framedStreamArray != null) {
                    for (FramedStream framedStream : framedStreamArray) {
                        try {
                            framedStream.close(errorCode2);
                        }
                        catch (IOException iOException2) {
                            if (iOException == null) continue;
                            iOException = iOException2;
                        }
                    }
                }
                if (pingArray != null) {
                    for (FramedStream framedStream : pingArray) {
                        ((Ping)((Object)framedStream)).cancel();
                    }
                }
                try {
                    this.frameWriter.close();
                }
                catch (IOException iOException4) {
                    if (iOException != null) break block19;
                    iOException = iOException4;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException5) {
                iOException = iOException5;
            }
            if (iOException != null) {
                throw iOException;
            }
            return;
        }
    }

    public void sendConnectionPreface() throws IOException {
        this.frameWriter.connectionPreface();
        this.frameWriter.settings(this.okHttpSettings);
        int n = this.okHttpSettings.getInitialWindowSize(65536);
        if (n != 65536) {
            this.frameWriter.windowUpdate(0, n - 65536);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Settings settings) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                this.okHttpSettings.merge(settings);
                this.frameWriter.settings(settings);
            }
        }
    }

    private boolean pushedStream(int n) {
        return this.protocol == Protocol.HTTP_2 && n != 0 && (n & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRequestLater(final int n, final List<Header> list) {
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.currentPushRequests.contains(n)) {
                this.writeSynResetLater(n, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block5: {
                    boolean bl = FramedConnection.this.pushObserver.onRequest(n, list);
                    try {
                        if (!bl) break block5;
                        FramedConnection.this.frameWriter.rstStream(n, ErrorCode.CANCEL);
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushHeadersLater(final int n, final List<Header> list, final boolean bl) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    boolean bl2 = FramedConnection.this.pushObserver.onHeaders(n, list, bl);
                    try {
                        if (bl2) {
                            FramedConnection.this.frameWriter.rstStream(n, ErrorCode.CANCEL);
                        }
                        if (!bl2 && !bl) break block6;
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushDataLater(final int n, BufferedSource bufferedSource, final int n2, final boolean bl) throws IOException {
        final Buffer buffer = new Buffer();
        bufferedSource.require(n2);
        bufferedSource.read(buffer, n2);
        if (buffer.size() != (long)n2) {
            throw new IOException(buffer.size() + " != " + n2);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean bl2 = FramedConnection.this.pushObserver.onData(n, buffer, n2, bl);
                        if (bl2) {
                            FramedConnection.this.frameWriter.rstStream(n, ErrorCode.CANCEL);
                        }
                        if (!bl2 && !bl) break block6;
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushResetLater(final int n, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostName, n}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                FramedConnection.this.pushObserver.onReset(n, errorCode);
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection.this.currentPushRequests.remove(n);
                }
            }
        });
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(FramedStream framedStream) throws IOException {
                framedStream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(FramedStream var1) throws IOException;

        public void onSettings(FramedConnection framedConnection) {
        }
    }

    class Reader
    extends NamedRunnable
    implements FrameReader.Handler {
        final FrameReader frameReader;

        private Reader(FrameReader frameReader) {
            super("OkHttp %s", FramedConnection.this.hostName);
            this.frameReader = frameReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
            try {
                if (!FramedConnection.this.client) {
                    this.frameReader.readConnectionPreface();
                }
                while (this.frameReader.nextFrame(this)) {
                }
                errorCode = ErrorCode.NO_ERROR;
                errorCode2 = ErrorCode.CANCEL;
            }
            catch (IOException iOException) {
                errorCode = ErrorCode.PROTOCOL_ERROR;
                errorCode2 = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    FramedConnection.this.close(errorCode, errorCode2);
                }
                catch (IOException iOException) {}
                Util.closeQuietly(this.frameReader);
            }
        }

        @Override
        public void data(boolean bl, int n, BufferedSource bufferedSource, int n2) throws IOException {
            if (FramedConnection.this.pushedStream(n)) {
                FramedConnection.this.pushDataLater(n, bufferedSource, n2, bl);
                return;
            }
            FramedStream framedStream = FramedConnection.this.getStream(n);
            if (framedStream == null) {
                FramedConnection.this.writeSynResetLater(n, ErrorCode.INVALID_STREAM);
                bufferedSource.skip(n2);
                return;
            }
            framedStream.receiveData(bufferedSource, n2);
            if (bl) {
                framedStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl, boolean bl2, int n, int n2, List<Header> list, HeadersMode headersMode) {
            FramedStream framedStream;
            if (FramedConnection.this.pushedStream(n)) {
                FramedConnection.this.pushHeadersLater(n, list, bl2);
                return;
            }
            FramedConnection framedConnection = FramedConnection.this;
            synchronized (framedConnection) {
                if (FramedConnection.this.shutdown) {
                    return;
                }
                framedStream = FramedConnection.this.getStream(n);
                if (framedStream == null) {
                    if (headersMode.failIfStreamAbsent()) {
                        FramedConnection.this.writeSynResetLater(n, ErrorCode.INVALID_STREAM);
                        return;
                    }
                    if (n <= FramedConnection.this.lastGoodStreamId) {
                        return;
                    }
                    if (n % 2 == FramedConnection.this.nextStreamId % 2) {
                        return;
                    }
                    final FramedStream framedStream2 = new FramedStream(n, FramedConnection.this, bl, bl2, list);
                    FramedConnection.this.lastGoodStreamId = n;
                    FramedConnection.this.streams.put(n, framedStream2);
                    executor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{FramedConnection.this.hostName, n}){

                        @Override
                        public void execute() {
                            try {
                                FramedConnection.this.listener.onStream(framedStream2);
                            }
                            catch (IOException iOException) {
                                Internal.logger.log(Level.INFO, "FramedConnection.Listener failure for " + FramedConnection.this.hostName, iOException);
                                try {
                                    framedStream2.close(ErrorCode.PROTOCOL_ERROR);
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            if (headersMode.failIfStreamPresent()) {
                framedStream.closeLater(ErrorCode.PROTOCOL_ERROR);
                FramedConnection.this.removeStream(n);
                return;
            }
            framedStream.receiveHeaders(list, headersMode);
            if (bl2) {
                framedStream.receiveFin();
            }
        }

        @Override
        public void rstStream(int n, ErrorCode errorCode) {
            if (FramedConnection.this.pushedStream(n)) {
                FramedConnection.this.pushResetLater(n, errorCode);
                return;
            }
            FramedStream framedStream = FramedConnection.this.removeStream(n);
            if (framedStream != null) {
                framedStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean bl, Settings settings) {
            int n;
            int n2;
            long l = 0L;
            FramedStream[] framedStreamArray = null;
            FramedConnection framedConnection = FramedConnection.this;
            synchronized (framedConnection) {
                n2 = FramedConnection.this.peerSettings.getInitialWindowSize(65536);
                if (bl) {
                    FramedConnection.this.peerSettings.clear();
                }
                FramedConnection.this.peerSettings.merge(settings);
                if (FramedConnection.this.getProtocol() == Protocol.HTTP_2) {
                    this.ackSettingsLater(settings);
                }
                if ((n = FramedConnection.this.peerSettings.getInitialWindowSize(65536)) != -1 && n != n2) {
                    l = n - n2;
                    if (!FramedConnection.this.receivedInitialPeerSettings) {
                        FramedConnection.this.addBytesToWriteWindow(l);
                        FramedConnection.this.receivedInitialPeerSettings = true;
                    }
                    if (!FramedConnection.this.streams.isEmpty()) {
                        framedStreamArray = FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]);
                    }
                }
                executor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{FramedConnection.this.hostName}){

                    @Override
                    public void execute() {
                        FramedConnection.this.listener.onSettings(FramedConnection.this);
                    }
                });
            }
            if (framedStreamArray != null && l != 0L) {
                framedConnection = framedStreamArray;
                n2 = ((FramedConnection)framedConnection).length;
                for (n = 0; n < n2; ++n) {
                    FramedConnection framedConnection2;
                    FramedConnection framedConnection3 = framedConnection2 = framedConnection[n];
                    synchronized (framedConnection3) {
                        ((FramedStream)((Object)framedConnection2)).addBytesToWriteWindow(l);
                        continue;
                    }
                }
            }
        }

        private void ackSettingsLater(final Settings settings) {
            executor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{FramedConnection.this.hostName}){

                @Override
                public void execute() {
                    try {
                        FramedConnection.this.frameWriter.ackSettings(settings);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void ping(boolean bl, int n, int n2) {
            if (bl) {
                Ping ping = FramedConnection.this.removePing(n);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                FramedConnection.this.writePingLater(true, n, n2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n, ErrorCode errorCode, ByteString byteString) {
            if (byteString.size() > 0) {
                // empty if block
            }
            FramedStream[] framedStreamArray = FramedConnection.this;
            synchronized (FramedConnection.this) {
                FramedStream[] framedStreamArray2 = FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]);
                FramedConnection.this.shutdown = true;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                for (FramedStream framedStream : framedStreamArray2) {
                    if (framedStream.getId() <= n || !framedStream.isLocallyInitiated()) continue;
                    framedStream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    FramedConnection.this.removeStream(framedStream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n, long l) {
            if (n == 0) {
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection.this.bytesLeftInWriteWindow += l;
                    FramedConnection.this.notifyAll();
                }
            }
            FramedStream framedStream = FramedConnection.this.getStream(n);
            if (framedStream != null) {
                FramedStream framedStream2 = framedStream;
                synchronized (framedStream2) {
                    framedStream.addBytesToWriteWindow(l);
                }
            }
        }

        @Override
        public void priority(int n, int n2, int n3, boolean bl) {
        }

        @Override
        public void pushPromise(int n, int n2, List<Header> list) {
            FramedConnection.this.pushRequestLater(n2, list);
        }

        @Override
        public void alternateService(int n, String string, ByteString byteString, String string2, int n2, long l) {
        }
    }

    public static class Builder {
        private Socket socket;
        private String hostName;
        private BufferedSource source;
        private BufferedSink sink;
        private Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        private Protocol protocol = Protocol.SPDY_3;
        private PushObserver pushObserver = PushObserver.CANCEL;
        private boolean client;

        public Builder(boolean bl) throws IOException {
            this.client = bl;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostName = string;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public FramedConnection build() throws IOException {
            return new FramedConnection(this);
        }
    }
}

