/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.HttpUrl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.ByteString;
import okio.Source;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Util() {
    }

    public static void checkOffsetAndCount(long l, long l2, long l3) {
        if ((l2 | l3) < 0L || l2 > l || l - l2 < l3) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError assertionError) {
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw assertionError;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable closeable, Closeable closeable2) throws IOException {
        Throwable throwable;
        block8: {
            throwable = null;
            try {
                closeable.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            try {
                closeable2.close();
            }
            catch (Throwable throwable3) {
                if (throwable != null) break block8;
                throwable = throwable3;
            }
        }
        if (throwable == null) {
            return;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new AssertionError((Object)throwable);
    }

    public static boolean discard(Source source2, int n, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source2, n, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean skipAll(Source source2, int n, TimeUnit timeUnit) throws IOException {
        long l = System.nanoTime();
        long l2 = source2.timeout().hasDeadline() ? source2.timeout().deadlineNanoTime() - l : Long.MAX_VALUE;
        source2.timeout().deadlineNanoTime(l + Math.min(l2, timeUnit.toNanos(n)));
        try {
            Buffer buffer = new Buffer();
            while (source2.read(buffer, 2048L) != -1L) {
                buffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException interruptedIOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (l2 == Long.MAX_VALUE) {
                source2.timeout().clearDeadline();
            } else {
                source2.timeout().deadlineNanoTime(l + l2);
            }
        }
    }

    public static String md5Hex(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            return ByteString.of(byArray).hex();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static String shaBase64(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            return ByteString.of(byArray).base64();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static ByteString sha1(ByteString byteString) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(byteString.toByteArray());
            return ByteString.of(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static ThreadFactory threadFactory(final String string, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = new Thread(runnable2, string);
                thread2.setDaemon(bl);
                return thread2;
            }
        };
    }

    public static <T> T[] intersect(Class<T> clazz, T[] TArray, T[] TArray2) {
        List<Object> list = Util.intersect(TArray, TArray2);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    private static <T> List<T> intersect(T[] TArray, T[] TArray2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        block0: for (T t2 : TArray) {
            for (T t3 : TArray2) {
                if (!t2.equals(t3)) continue;
                arrayList.add(t3);
                continue block0;
            }
        }
        return arrayList;
    }

    public static String hostHeader(HttpUrl httpUrl) {
        return httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme()) ? httpUrl.host() + ":" + httpUrl.port() : httpUrl.host();
    }

    public static String toHumanReadableAscii(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n > 31 && n < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, 0, i);
            for (int j = i; j < n2; j += Character.charCount(n)) {
                n = string.codePointAt(j);
                buffer.writeUtf8CodePoint(n > 31 && n < 127 ? n : 63);
            }
            return buffer.readUtf8();
        }
        return string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static boolean contains(String[] stringArray, String string) {
        return Arrays.asList(stringArray).contains(string);
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }
}

