/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    public OptionalMethod(Class<?> clazz, String string, Class ... classArray) {
        this.returnType = clazz;
        this.methodName = string;
        this.methodParams = classArray;
    }

    public boolean isSupported(T t2) {
        return this.getMethod(t2.getClass()) != null;
    }

    public Object invokeOptional(T t2, Object ... objectArray) throws InvocationTargetException {
        Method method = this.getMethod(t2.getClass());
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(t2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T t2, Object ... objectArray) {
        try {
            return this.invokeOptional(t2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            AssertionError assertionError = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)assertionError)).initCause(throwable);
            throw assertionError;
        }
    }

    public Object invoke(T t2, Object ... objectArray) throws InvocationTargetException {
        Method method = this.getMethod(t2.getClass());
        if (method == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + t2));
        }
        try {
            return method.invoke(t2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            AssertionError assertionError = new AssertionError((Object)("Unexpectedly could not call: " + method));
            ((Throwable)((Object)assertionError)).initCause(illegalAccessException);
            throw assertionError;
        }
    }

    public Object invokeWithoutCheckedException(T t2, Object ... objectArray) {
        try {
            return this.invoke(t2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            AssertionError assertionError = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)assertionError)).initCause(throwable);
            throw assertionError;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

