/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.FixedDateTimeZone;

public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    private static final long MILLI_SECONDS_OF_365_DAYS = 31536000000L;
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);

    public static String formatRFC822Date(Date date) {
        return rfc822DateFormat.print(date.getTime());
    }

    public static Date parseRFC822Date(String string) {
        return new Date(rfc822DateFormat.parseMillis(string));
    }

    public static String formatISO8601Date(Date date) {
        return iso8601DateFormat.print(date.getTime());
    }

    public static Date parseISO8601Date(String string) {
        if (string.endsWith("+0000")) {
            string = string.substring(0, string.length() - 5).concat("Z");
        }
        String string2 = DateUtils.tempDateStringForJodaTime(string);
        try {
            if (string2.equals(string)) {
                return new Date(iso8601DateFormat.parseMillis(string));
            }
            long l = iso8601DateFormat.parseMillis(string2);
            long l2 = l + 31536000000L;
            if (l2 < 0L) {
                return new Date(iso8601DateFormat.parseMillis(string));
            }
            return new Date(l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new Date(alternateIso8601DateFormat.parseMillis(string));
            }
            catch (Exception exception) {
                throw illegalArgumentException;
            }
        }
    }

    private static String tempDateStringForJodaTime(String string) {
        String string2 = "292278994-";
        String string3 = "292278993-";
        return string.startsWith("292278994-") ? "292278993-" + string.substring("292278994-".length()) : string;
    }
}

