/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.event.COSProgressPublisher;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.internal.UploadPartRequestFactory;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.EncryptedInitiateMultipartUploadRequest;
import com.qcloud.cos.model.EncryptedPutObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.UploadImpl;
import com.qcloud.cos.transfer.UploadPartCallable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCallable
implements Callable<UploadResult> {
    private final COS cos;
    private final ExecutorService threadPool;
    private final PutObjectRequest origReq;
    private String multipartUploadId;
    private final UploadImpl upload;
    private static final Logger log = LoggerFactory.getLogger(UploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listener;
    private final TransferProgress transferProgress;
    private final List<PartETag> eTagsToSkip = new ArrayList<PartETag>();
    private PersistableUpload persistableUpload;

    public UploadCallable(TransferManager transferManager, ExecutorService executorService, UploadImpl uploadImpl, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain, String string, TransferProgress transferProgress) {
        this.cos = transferManager.getCOSClient();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.upload = uploadImpl;
        this.multipartUploadId = string;
        this.transferProgress = transferProgress;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    List<PartETag> getETags() {
        return this.eTagsToSkip;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartUpload() {
        return TransferManagerUtils.shouldUseMultipartUpload(this.origReq, this.configuration);
    }

    @Override
    public UploadResult call() throws Exception {
        this.upload.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            return this.uploadInParts();
        }
        return this.uploadInOneChunk();
    }

    private UploadResult uploadInOneChunk() {
        PutObjectResult putObjectResult = this.cos.putObject(this.origReq);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.origReq.getBucketName());
        uploadResult.setKey(this.origReq.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        uploadResult.setRequestId(putObjectResult.getRequestId());
        uploadResult.setDateStr(putObjectResult.getDateStr());
        uploadResult.setCrc64Ecma(putObjectResult.getCrc64Ecma());
        uploadResult.setCiUploadResult(putObjectResult.getCiUploadResult());
        return uploadResult;
    }

    private void captureUploadStateIfPossible() {
        if (this.origReq.getSSECustomerKey() == null) {
            this.persistableUpload = new PersistableUpload(this.origReq.getBucketName(), this.origReq.getKey(), this.origReq.getFile().getAbsolutePath(), this.multipartUploadId, this.configuration.getMinimumUploadPartSize(), this.configuration.getMultipartUploadThreshold());
            this.notifyPersistableTransferAvailability();
        }
    }

    public PersistableUpload getPersistableUpload() {
        return this.persistableUpload;
    }

    private void notifyPersistableTransferAvailability() {
        COSProgressPublisher.publishTransferPersistable(this.listener, this.persistableUpload);
    }

    private UploadResult uploadInParts() throws Exception {
        boolean bl = this.cos instanceof COSEncryptionClient;
        long l = this.getOptimalPartSize(bl);
        try {
            if (this.multipartUploadId == null) {
                this.multipartUploadId = this.initiateMultipartUpload(this.origReq, bl, l);
            }
            UploadPartRequestFactory uploadPartRequestFactory = new UploadPartRequestFactory(this.origReq, this.multipartUploadId, l);
            if (TransferManagerUtils.isUploadParallelizable(this.origReq, bl)) {
                this.captureUploadStateIfPossible();
                this.uploadPartsInParallel(uploadPartRequestFactory, this.multipartUploadId);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(uploadPartRequestFactory);
            return uploadResult;
        }
        catch (Exception exception) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.performAbortMultipartUpload();
            throw exception;
        }
        finally {
            if (this.origReq.getInputStream() != null) {
                try {
                    this.origReq.getInputStream().close();
                }
                catch (Exception exception) {
                    log.warn("Unable to cleanly close input stream: " + exception.getMessage(), exception);
                }
            }
        }
    }

    void performAbortMultipartUpload() {
        try {
            if (this.multipartUploadId != null) {
                AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.multipartUploadId);
                TransferManagerUtils.populateEndpointAddr(this.origReq, abortMultipartUploadRequest);
                this.cos.abortMultipartUpload(abortMultipartUploadRequest);
            }
        }
        catch (Exception exception) {
            log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception.getMessage(), exception);
        }
    }

    private long getOptimalPartSize(boolean bl) {
        long l = TransferManagerUtils.calculateOptimalPartSize(this.origReq, this.configuration);
        if (bl && l % 32L > 0L) {
            l = l - l % 32L + 32L;
        }
        log.debug("Calculated optimal part size: " + l);
        return l;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory uploadPartRequestFactory) {
        ObjectExpirationResult objectExpirationResult;
        Object object;
        CosServiceRequest cosServiceRequest;
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        while (uploadPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            cosServiceRequest = uploadPartRequestFactory.getNextUploadPartRequest();
            object = ((UploadPartRequest)cosServiceRequest).getInputStream();
            if (object != null && ((InputStream)object).markSupported()) {
                if (((UploadPartRequest)cosServiceRequest).getPartSize() >= Integer.MAX_VALUE) {
                    ((InputStream)object).mark(Integer.MAX_VALUE);
                } else {
                    ((InputStream)object).mark((int)((UploadPartRequest)cosServiceRequest).getPartSize());
                }
            }
            arrayList.add(this.cos.uploadPart((UploadPartRequest)cosServiceRequest).getPartETag());
        }
        cosServiceRequest = (CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.multipartUploadId, arrayList).withGeneralProgressListener(this.origReq.getGeneralProgressListener());
        object = this.origReq.getMetadata();
        if (object != null) {
            objectExpirationResult = ((CompleteMultipartUploadRequest)cosServiceRequest).getObjectMetadata();
            if (objectExpirationResult == null) {
                objectExpirationResult = new ObjectMetadata();
            }
            ((ObjectMetadata)objectExpirationResult).setUserMetadata(((ObjectMetadata)object).getUserMetadata());
            ((CompleteMultipartUploadRequest)cosServiceRequest).setObjectMetadata((ObjectMetadata)objectExpirationResult);
        }
        if (this.origReq.getPicOperations() != null) {
            ((CompleteMultipartUploadRequest)cosServiceRequest).setPicOperations(this.origReq.getPicOperations());
        }
        TransferManagerUtils.populateEndpointAddr(this.origReq, cosServiceRequest);
        objectExpirationResult = this.cos.completeMultipartUpload((CompleteMultipartUploadRequest)cosServiceRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(((CompleteMultipartUploadResult)objectExpirationResult).getBucketName());
        uploadResult.setKey(((CompleteMultipartUploadResult)objectExpirationResult).getKey());
        uploadResult.setETag(((CompleteMultipartUploadResult)objectExpirationResult).getETag());
        uploadResult.setVersionId(((CompleteMultipartUploadResult)objectExpirationResult).getVersionId());
        uploadResult.setRequestId(((CompleteMultipartUploadResult)objectExpirationResult).getRequestId());
        uploadResult.setDateStr(((CompleteMultipartUploadResult)objectExpirationResult).getDateStr());
        uploadResult.setCrc64Ecma(((CompleteMultipartUploadResult)objectExpirationResult).getCrc64Ecma());
        uploadResult.setCiUploadResult(((CompleteMultipartUploadResult)objectExpirationResult).getCiUploadResult());
        return uploadResult;
    }

    private void uploadPartsInParallel(UploadPartRequestFactory uploadPartRequestFactory, String string) {
        Map<Integer, PartSummary> map = this.identifyExistingPartsForResume(string);
        while (uploadPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest uploadPartRequest = uploadPartRequestFactory.getNextUploadPartRequest();
            if (map.containsKey(uploadPartRequest.getPartNumber())) {
                PartSummary partSummary = map.get(uploadPartRequest.getPartNumber());
                this.eTagsToSkip.add(new PartETag(uploadPartRequest.getPartNumber(), partSummary.getETag()));
                this.transferProgress.updateProgress(partSummary.getSize());
                continue;
            }
            this.futures.add(this.threadPool.submit(new UploadPartCallable(this.cos, uploadPartRequest)));
        }
    }

    private Map<Integer, PartSummary> identifyExistingPartsForResume(String string) {
        HashMap<Integer, PartSummary> hashMap = new HashMap<Integer, PartSummary>();
        if (string == null) {
            return hashMap;
        }
        int n = 0;
        while (true) {
            ListPartsRequest listPartsRequest = new ListPartsRequest(this.origReq.getBucketName(), this.origReq.getKey(), string).withPartNumberMarker(n);
            TransferManagerUtils.populateEndpointAddr(this.origReq, listPartsRequest);
            PartListing partListing = this.cos.listParts(listPartsRequest);
            for (PartSummary partSummary : partListing.getParts()) {
                hashMap.put(partSummary.getPartNumber(), partSummary);
            }
            if (!partListing.isTruncated()) {
                return hashMap;
            }
            n = partListing.getNextPartNumberMarker();
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest, boolean bl, long l) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        if (bl && putObjectRequest instanceof EncryptedPutObjectRequest) {
            initiateMultipartUploadRequest = new EncryptedInitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
            ((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).setMaterialsDescription(((EncryptedPutObjectRequest)putObjectRequest).getMaterialsDescription());
        } else {
            initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        }
        long l2 = TransferManagerUtils.getContentLength(putObjectRequest);
        initiateMultipartUploadRequest.setDataSizePartSize(l2, l);
        TransferManager.appendMultipartUserAgent(initiateMultipartUploadRequest);
        initiateMultipartUploadRequest.withAccessControlList(putObjectRequest.getAccessControlList()).withStorageClass(putObjectRequest.getStorageClass()).withRedirectLocation(putObjectRequest.getRedirectLocation()).withSSECustomerKey(putObjectRequest.getSSECustomerKey()).withSSECOSKeyManagementParams(putObjectRequest.getSSECOSKeyManagementParams()).withGeneralProgressListener(putObjectRequest.getGeneralProgressListener());
        TransferManagerUtils.populateEndpointAddr(putObjectRequest, initiateMultipartUploadRequest);
        String string = this.cos.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug("Initiated new multipart upload: " + string);
        return string;
    }
}

