/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.transfer.RangeDownloadCallable;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResumableDownloadSubmitter {
    private static final Logger log = LoggerFactory.getLogger(ResumableDownloadSubmitter.class);
    private final COS cos;
    private final ExecutorService threadPool;
    private final GetObjectRequest req;
    private final DownloadImpl download;
    private final File destFile;
    private final RandomAccessFile destRandomAccessFile;
    private final FileChannel destFileChannel;
    private final int partSize;
    private final int multiThreadThreshold;
    private final TransferProgress transferProgress;
    private final ProgressListenerChain listener;
    private PersistableResumeDownload downloadRecord;
    private List<Future<DownloadPart>> futures = new ArrayList<Future<DownloadPart>>();
    private List<DownloadPart> skippedParts = new ArrayList<DownloadPart>();

    ResumableDownloadSubmitter(COS cOS, ExecutorService executorService, GetObjectRequest getObjectRequest, DownloadImpl downloadImpl, File file, RandomAccessFile randomAccessFile, FileChannel fileChannel, PersistableResumeDownload persistableResumeDownload, int n, int n2, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        if (cOS == null || executorService == null || getObjectRequest == null || downloadImpl == null || file == null || randomAccessFile == null || fileChannel == null || persistableResumeDownload == null) {
            throw new IllegalArgumentException("arguments in ResumableDownloadSubmitter must not be null");
        }
        this.cos = cOS;
        this.threadPool = executorService;
        this.req = getObjectRequest;
        this.download = downloadImpl;
        this.destFile = file;
        this.destRandomAccessFile = randomAccessFile;
        this.destFileChannel = fileChannel;
        this.downloadRecord = persistableResumeDownload;
        this.partSize = n;
        this.multiThreadThreshold = n2;
        this.transferProgress = transferProgress;
        this.listener = progressListenerChain;
    }

    public void submit() throws Exception {
        long l = Long.parseLong(this.downloadRecord.getContentLength());
        this.download.setState(Transfer.TransferState.InProgress);
        if (l < (long)this.multiThreadThreshold) {
            throw new CosClientException("contentLenth " + l + " < " + this.multiThreadThreshold + " should not use resumabledownload.");
        }
        long l2 = 0L;
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_STARTED_EVENT);
        while (l > l2) {
            Object object;
            long l3;
            long l4 = l2 + l3 - 1L;
            String string = String.format("%d-%d", l2, l4);
            if (this.downloadRecord.hasDownloadedBlocks(string)) {
                int n;
                long l5;
                log.debug("part found in download record: " + string);
                object = new CRC64();
                byte[] byArray = new byte[10240];
                this.destRandomAccessFile.seek(l2);
                for (l3 = Math.min((long)this.partSize, l - l2); l3 > 0L && (n = this.destRandomAccessFile.read(byArray)) != -1; l3 -= l5) {
                    l5 = Math.min((long)n, l3);
                    ((CRC64)object).update(byArray, (int)l5);
                }
                this.skippedParts.add(new DownloadPart(l2, l4, ((CRC64)object).getValue()));
                this.transferProgress.updateProgress(l4 + 1L - l2);
            } else {
                object = this.copyGetObjectRequest(this.req);
                ((GetObjectRequest)object).setRange(l2, l4);
                if (this.threadPool.isShutdown()) {
                    SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
                    throw new CancellationException("TransferManager has been shutdown");
                }
                this.futures.add(this.threadPool.submit(new RangeDownloadCallable(this.cos, (GetObjectRequest)object, this.destFile, this.destFileChannel, this.downloadRecord)));
            }
            l2 = l4 + 1L;
        }
    }

    GetObjectRequest copyGetObjectRequest(GetObjectRequest getObjectRequest) {
        GetObjectRequest getObjectRequest2 = new GetObjectRequest(getObjectRequest.getCOSObjectId());
        getObjectRequest2.setCosCredentials(getObjectRequest.getCosCredentials());
        getObjectRequest2.setFixedEndpointAddr(getObjectRequest.getFixedEndpointAddr());
        getObjectRequest2.setGeneralProgressListener(getObjectRequest.getGeneralProgressListener());
        getObjectRequest2.setMatchingETagConstraints(getObjectRequest.getMatchingETagConstraints());
        getObjectRequest2.setModifiedSinceConstraint(getObjectRequest.getModifiedSinceConstraint());
        getObjectRequest2.setNonmatchingETagConstraints(getObjectRequest.getNonmatchingETagConstraints());
        getObjectRequest2.setResponseHeaders(getObjectRequest.getResponseHeaders());
        getObjectRequest2.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
        getObjectRequest2.setTrafficLimit(getObjectRequest.getTrafficLimit());
        getObjectRequest2.setUnmodifiedSinceConstraint(getObjectRequest.getUnmodifiedSinceConstraint());
        return getObjectRequest2;
    }

    List<Future<DownloadPart>> getFutures() {
        return this.futures;
    }

    List<DownloadPart> getSkippedParts() {
        return this.skippedParts;
    }
}

