/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.UploadMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompleteMultipartUpload
implements Callable<UploadResult> {
    private final String uploadId;
    private final COS cos;
    private final PutObjectRequest origReq;
    private final List<Future<PartETag>> futures;
    private final List<PartETag> eTagsBeforeResume;
    private final UploadMonitor monitor;
    private final ProgressListenerChain listener;

    public CompleteMultipartUpload(String string, COS cOS, PutObjectRequest putObjectRequest, List<Future<PartETag>> list, List<PartETag> list2, ProgressListenerChain progressListenerChain, UploadMonitor uploadMonitor) {
        this.uploadId = string;
        this.cos = cOS;
        this.origReq = putObjectRequest;
        this.futures = list;
        this.eTagsBeforeResume = list2;
        this.listener = progressListenerChain;
        this.monitor = uploadMonitor;
    }

    @Override
    public UploadResult call() throws Exception {
        CompleteMultipartUploadResult completeMultipartUploadResult;
        Object object;
        try {
            object = (CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.uploadId, this.collectPartETags()).withGeneralProgressListener(this.origReq.getGeneralProgressListener());
            ObjectMetadata objectMetadata = this.origReq.getMetadata();
            if (objectMetadata != null) {
                ObjectMetadata objectMetadata2 = ((CompleteMultipartUploadRequest)object).getObjectMetadata();
                if (objectMetadata2 == null) {
                    objectMetadata2 = new ObjectMetadata();
                }
                objectMetadata2.setUserMetadata(objectMetadata.getUserMetadata());
                ((CompleteMultipartUploadRequest)object).setObjectMetadata(objectMetadata2);
            }
            if (this.origReq.getPicOperations() != null) {
                ((CompleteMultipartUploadRequest)object).setPicOperations(this.origReq.getPicOperations());
            }
            TransferManagerUtils.populateEndpointAddr(this.origReq, (CosServiceRequest)object);
            completeMultipartUploadResult = this.cos.completeMultipartUpload((CompleteMultipartUploadRequest)object);
        }
        catch (Exception exception) {
            this.monitor.uploadFailed();
            throw exception;
        }
        object = new UploadResult();
        ((UploadResult)object).setBucketName(this.origReq.getBucketName());
        ((UploadResult)object).setKey(this.origReq.getKey());
        ((UploadResult)object).setETag(completeMultipartUploadResult.getETag());
        ((UploadResult)object).setVersionId(completeMultipartUploadResult.getVersionId());
        ((UploadResult)object).setRequestId(completeMultipartUploadResult.getRequestId());
        ((UploadResult)object).setDateStr(completeMultipartUploadResult.getDateStr());
        ((UploadResult)object).setCrc64Ecma(completeMultipartUploadResult.getCrc64Ecma());
        ((UploadResult)object).setCiUploadResult(completeMultipartUploadResult.getCiUploadResult());
        this.monitor.uploadComplete();
        return object;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        arrayList.addAll(this.eTagsBeforeResume);
        for (Future<PartETag> future : this.futures) {
            try {
                arrayList.add(future.get());
            }
            catch (Exception exception) {
                throw new CosClientException("Unable to complete multi-part upload. Individual part upload failed : " + exception.getCause().getMessage(), exception.getCause());
            }
        }
        return arrayList;
    }
}

