/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.transform;

import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.model.Stats;
import com.qcloud.cos.model.transform.SimpleTypeStaxUnmarshallers;
import com.qcloud.cos.model.transform.StaxUnmarshallerContext;
import javax.xml.stream.events.XMLEvent;

class StatsStaxUnmarshaller
implements Unmarshaller<Stats, StaxUnmarshallerContext> {
    private static final StatsStaxUnmarshaller instance = new StatsStaxUnmarshaller();

    public static StatsStaxUnmarshaller getInstance() {
        return instance;
    }

    private StatsStaxUnmarshaller() {
    }

    @Override
    public Stats unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        Stats stats = new Stats();
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return stats;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("BytesScanned", n2)) {
                    stats.setBytesScanned(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (staxUnmarshallerContext.testExpression("BytesReturned", n2)) {
                    stats.setBytesReturned(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (!staxUnmarshallerContext.testExpression("BytesProcessed", n2)) continue;
                stats.setBytesProcessed(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return stats;
    }
}

