/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.common.MediaInputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileHashCodeConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessOperation;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.FileUnCompressConfig;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import java.util.List;

public class CIFileProcessXmlFactory {
    public static byte[] convertToXmlByteArray(FileProcessRequest fileProcessRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Tag").value(fileProcessRequest.getTag().toString()).end();
        CIFileProcessXmlFactory.addInput(xmlWriter, fileProcessRequest.getInput());
        CIFileProcessXmlFactory.addOperation(xmlWriter, fileProcessRequest.getOperation());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "QueueId", fileProcessRequest.getQueueId());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBack", fileProcessRequest.getCallBack());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBackFormat", fileProcessRequest.getCallBackFormat());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBackType", fileProcessRequest.getCallBackType());
        CIMediaXmlFactory.addIfNotNull(xmlWriter, "CallBackMqConfig", fileProcessRequest.getCallBackMqConfig());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addInput(XmlWriter xmlWriter, MediaInputObject mediaInputObject) {
        if (CIMediaXmlFactory.objIsNotValid(mediaInputObject).booleanValue()) {
            xmlWriter.start("Input");
            xmlWriter.start("Object").value(mediaInputObject.getObject()).end();
            xmlWriter.end();
        }
    }

    private static void addOperation(XmlWriter xmlWriter, FileProcessOperation fileProcessOperation) {
        if (CIMediaXmlFactory.objIsNotValid(fileProcessOperation).booleanValue()) {
            FileHashCodeConfig fileHashCodeConfig;
            xmlWriter.start("Operation");
            CIMediaXmlFactory.addIfNotNull(xmlWriter, "UserData", fileProcessOperation.getUserData());
            FileCompressConfig fileCompressConfig = fileProcessOperation.getFileCompressConfig();
            if (CIMediaXmlFactory.objIsNotValid(fileCompressConfig).booleanValue()) {
                xmlWriter.start("FileCompressConfig");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Flatten", fileCompressConfig.getFlatten());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Format", fileCompressConfig.getFormat());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "UrlList", fileCompressConfig.getUrlList());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Prefix", fileCompressConfig.getPrefix());
                List<String> list = fileCompressConfig.getKey();
                if (!list.isEmpty()) {
                    for (String string : list) {
                        xmlWriter.start("Key").value(string).end();
                    }
                }
                xmlWriter.end();
            } else if (CIMediaXmlFactory.objIsNotValid(fileProcessOperation.getFileUnCompressConfig()).booleanValue()) {
                FileUnCompressConfig fileUnCompressConfig = fileProcessOperation.getFileUnCompressConfig();
                if (CIMediaXmlFactory.objIsNotValid(fileUnCompressConfig).booleanValue()) {
                    xmlWriter.start("FileUncompressConfig");
                    CIMediaXmlFactory.addIfNotNull(xmlWriter, "Prefix", fileUnCompressConfig.getPrefix());
                    CIMediaXmlFactory.addIfNotNull(xmlWriter, "PrefixReplaced", fileUnCompressConfig.getPrefixReplaced());
                    xmlWriter.end();
                }
            } else if (CIMediaXmlFactory.objIsNotValid(fileProcessOperation.getFileHashCodeConfig()).booleanValue() && CIMediaXmlFactory.objIsNotValid(fileHashCodeConfig = fileProcessOperation.getFileHashCodeConfig()).booleanValue()) {
                xmlWriter.start("FileHashCodeConfig");
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "Type", fileHashCodeConfig.getType());
                CIMediaXmlFactory.addIfNotNull(xmlWriter, "AddToHeader", fileHashCodeConfig.getAddToHeader());
                xmlWriter.end();
            }
            CIMediaXmlFactory.addOutput(xmlWriter, fileProcessOperation.getOutput());
            xmlWriter.end();
        }
    }
}

