/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.internal.ObjectRestoreResult;
import com.qcloud.cos.internal.ServerSideEncryptionResult;
import com.qcloud.cos.model.CosServiceResult;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata
extends CosServiceResult
implements ObjectExpirationResult,
ObjectRestoreResult,
ServerSideEncryptionResult,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;
    private boolean isDeleteMarker;
    private boolean isFileModeDir;
    private CIUploadResult ciUploadResult;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> map) {
        this.userMetadata = map;
    }

    public void setHeader(String string, Object object) {
        this.metadata.put(string, object);
    }

    public void addUserMetadata(String string, String string2) {
        this.userMetadata.put(string, string2);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Object getRawMetadataValue(String string) {
        return this.metadata.get(string);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date date) {
        this.metadata.put("Last-Modified", date);
    }

    public long getContentLength() {
        Long l = (Long)this.metadata.get("Content-Length");
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public long getInstanceLength() {
        int n;
        String string = (String)this.metadata.get("Content-Range");
        if (string != null && (n = string.lastIndexOf("/")) >= 0) {
            return Long.parseLong(string.substring(n + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long l) {
        this.metadata.put("Content-Length", l);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String string) {
        this.metadata.put("Content-Type", string);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String string) {
        this.metadata.put("Content-Language", string);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String string) {
        this.metadata.put("Content-Encoding", string);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String string) {
        this.metadata.put("Cache-Control", string);
    }

    public void setContentMD5(String string) {
        if (string == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", string);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String string) {
        this.metadata.put("Content-Disposition", string);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public void setETag(String string) {
        this.metadata.put("ETag", string);
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-cos-version-id");
    }

    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    public void setServerSideEncryption(String string) {
        this.metadata.put("x-cos-server-side-encryption", string);
    }

    public void setSecurityToken(String string) {
        this.metadata.put("x-cos-security-token", string);
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(Date date) {
        this.expirationTime = date;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String string) {
        this.expirationTimeRuleId = string;
    }

    public void setHttpExpiresDate(Date date) {
        this.httpExpiresDate = date;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    @Override
    public void setRestoreExpirationTime(Date date) {
        this.restoreExpirationTime = date;
    }

    @Override
    public void setOngoingRestore(boolean bl) {
        this.ongoingRestore = bl;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public boolean isDeleteMarker() {
        return this.isDeleteMarker;
    }

    public void setDeleteMarker(boolean bl) {
        this.isDeleteMarker = bl;
    }

    public boolean isFileModeDir() {
        return this.isFileModeDir;
    }

    public void setFileModeDir(boolean bl) {
        this.isFileModeDir = bl;
    }

    public String getUserMetaDataOf(String string) {
        return this.userMetadata == null ? null : this.userMetadata.get(string);
    }

    public ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
        this.isFileModeDir = false;
    }

    private ObjectMetadata(ObjectMetadata objectMetadata) {
        this.userMetadata = objectMetadata.userMetadata == null ? null : new HashMap<String, String>(objectMetadata.userMetadata);
        this.metadata = objectMetadata.metadata == null ? null : new HashMap<String, Object>(objectMetadata.metadata);
        this.expirationTime = objectMetadata.expirationTime;
        this.expirationTimeRuleId = objectMetadata.expirationTimeRuleId;
        this.httpExpiresDate = objectMetadata.httpExpiresDate;
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }

    @Override
    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    @Override
    public void setSSEAlgorithm(String string) {
        this.metadata.put("x-cos-server-side-encryption", string);
    }

    @Override
    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-algorithm");
    }

    @Override
    public void setSSECustomerAlgorithm(String string) {
        this.metadata.put("x-cos-server-side-encryption-customer-algorithm", string);
    }

    @Override
    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-key-MD5");
    }

    @Override
    public void setSSECustomerKeyMd5(String string) {
        this.metadata.put("x-cos-server-side-encryption-customer-key-MD5", string);
    }

    public String getStorageClass() {
        Object object = this.metadata.get("x-cos-storage-class");
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public StorageClass getStorageClassEnum() {
        String string = this.getStorageClass();
        StorageClass storageClass = null;
        if (string != null) {
            storageClass = StorageClass.fromValue(string);
        }
        return storageClass;
    }

    public String getSSECOSKmsKeyId() {
        return (String)this.metadata.get("x-cos-server-side-encryption-qcloud-kms-key-id");
    }

    public String getCrc64Ecma() {
        return (String)this.metadata.get("x-cos-hash-crc64ecma");
    }

    @Override
    public String getRequestId() {
        return (String)this.metadata.get("x-cos-request-id");
    }

    public CIUploadResult getCiUploadResult() {
        return this.ciUploadResult;
    }

    public void setCiUploadResult(CIUploadResult cIUploadResult) {
        this.ciUploadResult = cIUploadResult;
    }
}

