/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.UinGrantee;

public class AclXmlFactory {
    public byte[] convertToXmlByteArray(AccessControlList accessControlList) throws CosClientException {
        Owner owner = accessControlList.getOwner();
        if (owner == null) {
            throw new CosClientException("Invalid AccessControlList: missing an COS Owner");
        }
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("AccessControlPolicy");
        xmlWriter.start("Owner");
        if (owner.getId() != null) {
            xmlWriter.start("ID").value(owner.getId()).end();
        }
        if (owner.getDisplayName() != null) {
            xmlWriter.start("DisplayName").value(owner.getDisplayName()).end();
        }
        xmlWriter.end();
        xmlWriter.start("AccessControlList");
        for (Grant grant : accessControlList.getGrantsAsList()) {
            xmlWriter.start("Grant");
            this.convertToXml(grant.getGrantee(), xmlWriter);
            xmlWriter.start("Permission").value(grant.getPermission().toString()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    protected XmlWriter convertToXml(Grantee grantee, XmlWriter xmlWriter) throws CosClientException {
        if (grantee instanceof UinGrantee) {
            return this.convertToXml((UinGrantee)grantee, xmlWriter);
        }
        if (grantee instanceof GroupGrantee) {
            return this.convertToXml((GroupGrantee)grantee, xmlWriter);
        }
        throw new CosClientException("Unknown Grantee type: " + grantee.getClass().getName());
    }

    protected XmlWriter convertToXml(UinGrantee uinGrantee, XmlWriter xmlWriter) {
        xmlWriter.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "RootAccount"});
        xmlWriter.start("ID").value(uinGrantee.getIdentifier()).end();
        xmlWriter.end();
        return xmlWriter;
    }

    protected XmlWriter convertToXml(GroupGrantee groupGrantee, XmlWriter xmlWriter) {
        xmlWriter.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "Group"});
        xmlWriter.start("URI").value(groupGrantee.getIdentifier()).end();
        xmlWriter.end();
        return xmlWriter;
    }
}

