/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.eventstreaming;

import com.qcloud.cos.internal.eventstreaming.HeaderValue;
import com.qcloud.cos.internal.eventstreaming.Utils;
import com.qcloud.cos.utils.ValidationUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

class Header {
    private final String name;
    private final HeaderValue value;

    Header(String string, HeaderValue headerValue) {
        this.name = ValidationUtils.assertNotNull(string, "value");
        this.value = ValidationUtils.assertNotNull(headerValue, "value");
    }

    Header(String string, String string2) {
        this(string, HeaderValue.fromString(string2));
    }

    public String getName() {
        return this.name;
    }

    public HeaderValue getValue() {
        return this.value;
    }

    static Header decode(ByteBuffer byteBuffer) {
        String string = Utils.readShortString(byteBuffer);
        return new Header(string, HeaderValue.decode(byteBuffer));
    }

    static void encode(Map.Entry<String, HeaderValue> entry, DataOutputStream dataOutputStream) throws IOException {
        new Header(entry.getKey(), entry.getValue()).encode(dataOutputStream);
    }

    void encode(DataOutputStream dataOutputStream) throws IOException {
        Utils.writeShortString(dataOutputStream, this.name);
        this.value.encode(dataOutputStream);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Header header = (Header)object;
        if (!this.name.equals(header.name)) {
            return false;
        }
        return this.value.equals(header.value);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        return n;
    }

    public String toString() {
        return "Header{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

