/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAE;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAECbc;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAEStrict;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import java.io.File;

public class CryptoModuleDispatcher
extends COSCryptoModule {
    private final CryptoMode defaultCryptoMode;
    private final COSCryptoModuleAE ae;

    public CryptoModuleDispatcher(QCLOUDKMS qCLOUDKMS, COSDirect cOSDirect, COSCredentialsProvider cOSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        cryptoConfiguration = cryptoConfiguration.clone();
        CryptoMode cryptoMode = cryptoConfiguration.getCryptoMode();
        if (cryptoMode == null) {
            cryptoMode = CryptoMode.AuthenticatedEncryption;
            cryptoConfiguration.setCryptoMode(cryptoMode);
        }
        cryptoConfiguration = cryptoConfiguration.readOnly();
        this.defaultCryptoMode = cryptoConfiguration.getCryptoMode();
        switch (this.defaultCryptoMode) {
            case StrictAuthenticatedEncryption: {
                this.ae = new COSCryptoModuleAEStrict(qCLOUDKMS, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                break;
            }
            case AuthenticatedEncryption: {
                this.ae = new COSCryptoModuleAE(qCLOUDKMS, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                break;
            }
            case AesCtrEncryption: {
                this.ae = new COSCryptoModuleAE(qCLOUDKMS, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                break;
            }
            case AesCbcEncryption: {
                this.ae = new COSCryptoModuleAECbc(qCLOUDKMS, cOSDirect, cOSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public COSObject getObjectSecurely(GetObjectRequest getObjectRequest) {
        return this.ae.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        return this.ae.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws CosClientException, CosServiceException {
        return this.ae.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.ae.abortMultipartUploadSecurely(abortMultipartUploadRequest);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws CosClientException, CosServiceException {
        return this.ae.initiateMultipartUploadSecurely(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        return this.ae.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        return this.ae.copyPartSecurely(copyPartRequest);
    }

    @Override
    public PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest putInstructionFileRequest) {
        return this.ae.putInstructionFileSecurely(putInstructionFileRequest);
    }
}

