/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;

class CipherLite {
    static final CipherLite Null = new CipherLite(){

        @Override
        CipherLite createAuxiliary(long l) {
            return this;
        }

        @Override
        CipherLite createInverse() {
            return this;
        }
    };
    private final Cipher cipher;
    private final ContentCryptoScheme scheme;
    private final SecretKey secreteKey;
    private final int cipherMode;

    private CipherLite() {
        this.cipher = new NullCipher();
        this.scheme = null;
        this.secreteKey = null;
        this.cipherMode = -1;
    }

    CipherLite(Cipher cipher, ContentCryptoScheme contentCryptoScheme, SecretKey secretKey, int n) {
        this.cipher = cipher;
        this.scheme = contentCryptoScheme;
        this.secreteKey = secretKey;
        this.cipherMode = n;
    }

    CipherLite recreate() {
        return this.scheme.createCipherLite(this.secreteKey, this.cipher.getIV(), this.cipherMode, this.cipher.getProvider());
    }

    CipherLite createUsingIV(byte[] byArray) {
        return this.scheme.createCipherLite(this.secreteKey, byArray, this.cipherMode, this.cipher.getProvider());
    }

    CipherLite createAuxiliary(long l) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.scheme.createAuxillaryCipher(this.secreteKey, this.cipher.getIV(), this.cipherMode, this.cipher.getProvider(), l);
    }

    CipherLite createInverse() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        int n;
        if (this.cipherMode == 2) {
            n = 1;
        } else if (this.cipherMode == 1) {
            n = 2;
        } else {
            throw new UnsupportedOperationException();
        }
        return this.scheme.createCipherLite(this.secreteKey, this.cipher.getIV(), n, this.cipher.getProvider());
    }

    byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal();
    }

    byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray);
    }

    byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    byte[] update(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    final String getCipherAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    final Provider getCipherProvider() {
        return this.cipher.getProvider();
    }

    final String getSecretKeyAlgorithm() {
        return this.secreteKey.getAlgorithm();
    }

    final Cipher getCipher() {
        return this.cipher;
    }

    final ContentCryptoScheme getContentCryptoScheme() {
        return this.scheme;
    }

    final byte[] getIV() {
        return this.cipher.getIV();
    }

    final int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    final int getCipherMode() {
        return this.cipherMode;
    }

    boolean markSupported() {
        return false;
    }

    long mark() {
        return -1L;
    }

    void reset() {
        throw new IllegalStateException("mark/reset not supported");
    }

    int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }
}

