/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.CryptoRuntime;
import java.security.Key;

class COSKeyWrapScheme {
    public static final String AESWrap = "AESWrap";
    public static final String RSA_ECB_OAEPWithSHA256AndMGF1Padding = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    COSKeyWrapScheme() {
    }

    String getKeyWrapAlgorithm(Key key) {
        String string = key.getAlgorithm();
        if ("AES".equals(string)) {
            return AESWrap;
        }
        if ("RSA".equals(string) && CryptoRuntime.isRsaKeyWrapAvailable()) {
            return RSA_ECB_OAEPWithSHA256AndMGF1Padding;
        }
        throw new IllegalArgumentException("Unsupported key wrap algorithm " + string);
    }

    public String toString() {
        return "COSKeyWrapScheme";
    }
}

