/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.SdkInputStream;
import com.qcloud.cos.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public class AdjustedRangeInputStream
extends SdkInputStream {
    private InputStream decryptedContents;
    private long virtualAvailable;
    private boolean closed;

    public AdjustedRangeInputStream(InputStream inputStream2, long l, long l2) throws IOException {
        this.decryptedContents = inputStream2;
        this.closed = false;
        this.initializeForRead(l, l2);
    }

    private void initializeForRead(long l, long l2) throws IOException {
        int n;
        if (l < 16L) {
            n = (int)l;
        } else {
            int n2 = (int)(l % 16L);
            n = 16 + n2;
        }
        if (n != 0) {
            while (n > 0) {
                this.decryptedContents.read();
                --n;
            }
        }
        this.virtualAvailable = l2 - l + 1L;
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        int n = this.virtualAvailable <= 0L ? -1 : this.decryptedContents.read();
        if (n != -1) {
            --this.virtualAvailable;
        } else {
            this.virtualAvailable = 0L;
            this.close();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.abortIfNeeded();
        if (this.virtualAvailable <= 0L) {
            n3 = -1;
        } else {
            if ((long)n2 > this.virtualAvailable) {
                n2 = this.virtualAvailable < Integer.MAX_VALUE ? (int)this.virtualAvailable : Integer.MAX_VALUE;
            }
            n3 = this.decryptedContents.read(byArray, n, n2);
        }
        if (n3 != -1) {
            this.virtualAvailable -= (long)n3;
        } else {
            this.virtualAvailable = 0L;
            this.close();
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        int n = this.decryptedContents.available();
        if ((long)n < this.virtualAvailable) {
            return n;
        }
        return (int)this.virtualAvailable;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.virtualAvailable == 0L) {
                IOUtils.drainInputStream(this.decryptedContents);
            }
            this.decryptedContents.close();
        }
        this.abortIfNeeded();
    }

    @Override
    protected InputStream getWrappedInputStream() {
        return this.decryptedContents;
    }
}

