/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.CASJobParameters;
import com.qcloud.cos.model.CSVInput;
import com.qcloud.cos.model.CSVOutput;
import com.qcloud.cos.model.InputSerialization;
import com.qcloud.cos.model.JSONInput;
import com.qcloud.cos.model.JSONOutput;
import com.qcloud.cos.model.OutputSerialization;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.RequestProgress;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.ScanRange;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectParameters;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Conf;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.UserInfo;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingRequest;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.DocJobObject;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoRequest;
import com.qcloud.cos.model.ciModel.queue.DocQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.workflow.MediaOperation;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowDependency;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowNode;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowRequest;
import com.qcloud.cos.utils.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> list) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("CompleteMultipartUpload");
        if (list != null) {
            Collections.sort(list, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag partETag, PartETag partETag2) {
                    if (partETag.getPartNumber() < partETag2.getPartNumber()) {
                        return -1;
                    }
                    if (partETag.getPartNumber() > partETag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partETag : list) {
                xmlWriter.start("Part");
                xmlWriter.start("PartNumber").value(Integer.toString(partETag.getPartNumber())).end();
                xmlWriter.start("ETag").value(partETag.getETag()).end();
                xmlWriter.end();
            }
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(SelectObjectContentRequest selectObjectContentRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("SelectObjectContentRequest");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Expression", selectObjectContentRequest.getExpression());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ExpressionType", selectObjectContentRequest.getExpressionType());
        RequestXmlFactory.addScanRangeIfNotNull(xmlWriter, selectObjectContentRequest.getScanRange());
        RequestXmlFactory.addRequestProgressIfNotNull(xmlWriter, selectObjectContentRequest.getRequestProgress());
        RequestXmlFactory.addInputSerializationIfNotNull(xmlWriter, selectObjectContentRequest.getInputSerialization());
        RequestXmlFactory.addOutputSerializationIfNotNull(xmlWriter, selectObjectContentRequest.getOutputSerialization());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addRequestProgressIfNotNull(XmlWriter xmlWriter, RequestProgress requestProgress) {
        if (requestProgress == null) {
            return;
        }
        xmlWriter.start("RequestProgress");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Enabled", requestProgress.getEnabled());
        xmlWriter.end();
    }

    private static void addSelectParametersIfNotNull(XmlWriter xmlWriter, SelectParameters selectParameters) {
        if (selectParameters == null) {
            return;
        }
        xmlWriter.start("SelectParameters");
        RequestXmlFactory.addInputSerializationIfNotNull(xmlWriter, selectParameters.getInputSerialization());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ExpressionType", selectParameters.getExpressionType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Expression", selectParameters.getExpression());
        RequestXmlFactory.addOutputSerializationIfNotNull(xmlWriter, selectParameters.getOutputSerialization());
        xmlWriter.end();
    }

    private static void addScanRangeIfNotNull(XmlWriter xmlWriter, ScanRange scanRange) {
        if (scanRange != null) {
            xmlWriter.start("ScanRange");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Start", scanRange.getStart());
            RequestXmlFactory.addIfNotNull(xmlWriter, "End", scanRange.getEnd());
            xmlWriter.end();
        }
    }

    private static void addInputSerializationIfNotNull(XmlWriter xmlWriter, InputSerialization inputSerialization) {
        if (inputSerialization != null) {
            Serializable serializable;
            xmlWriter.start("InputSerialization");
            if (inputSerialization.getCsv() != null) {
                xmlWriter.start("CSV");
                serializable = inputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xmlWriter, "FileHeaderInfo", ((CSVInput)serializable).getFileHeaderInfo());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Comments", ((CSVInput)serializable).getCommentsAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteEscapeCharacter", ((CSVInput)serializable).getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((CSVInput)serializable).getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FieldDelimiter", ((CSVInput)serializable).getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteCharacter", ((CSVInput)serializable).getQuoteCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "AllowQuotedRecordDelimiter", ((CSVInput)serializable).getAllowQuotedRecordDelimiter());
                xmlWriter.end();
            }
            if (inputSerialization.getJson() != null) {
                xmlWriter.start("JSON");
                serializable = inputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xmlWriter, "Type", ((JSONInput)serializable).getType());
                xmlWriter.end();
            }
            if (inputSerialization.getParquet() != null) {
                xmlWriter.start("Parquet");
                xmlWriter.end();
            }
            RequestXmlFactory.addIfNotNull(xmlWriter, "CompressionType", inputSerialization.getCompressionType());
            xmlWriter.end();
        }
    }

    private static void addOutputSerializationIfNotNull(XmlWriter xmlWriter, OutputSerialization outputSerialization) {
        if (outputSerialization != null) {
            Serializable serializable;
            xmlWriter.start("OutputSerialization");
            if (outputSerialization.getCsv() != null) {
                xmlWriter.start("CSV");
                serializable = outputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteFields", ((CSVOutput)serializable).getQuoteFields());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteEscapeCharacter", ((CSVOutput)serializable).getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((CSVOutput)serializable).getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FieldDelimiter", ((CSVOutput)serializable).getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteCharacter", ((CSVOutput)serializable).getQuoteCharacterAsString());
                xmlWriter.end();
            }
            if (outputSerialization.getJson() != null) {
                xmlWriter.start("JSON");
                serializable = outputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((JSONOutput)serializable).getRecordDelimiterAsString());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws CosClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("RestoreRequest");
        xmlWriter.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        CASJobParameters cASJobParameters = restoreObjectRequest.getCasJobParameters();
        if (cASJobParameters != null) {
            xmlWriter.start("CASJobParameters");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Tier", cASJobParameters.getTier());
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaWorkflowRequest mediaWorkflowRequest) throws CosClientException, UnsupportedEncodingException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("MediaWorkflow");
        xmlWriter.start("Name").value(mediaWorkflowRequest.getName()).end();
        RequestXmlFactory.addIfNotNull(xmlWriter, "State", mediaWorkflowRequest.getState());
        RequestXmlFactory.addIfNotNull(xmlWriter, "WorkflowId", mediaWorkflowRequest.getWorkflowId());
        xmlWriter.start("Topology");
        xmlWriter.start("Dependencies");
        Map<String, MediaWorkflowDependency> map = mediaWorkflowRequest.getTopology().getMediaWorkflowDependency();
        for (String object : map.keySet()) {
            xmlWriter.start(object).value(map.get(object).getValue()).end();
        }
        xmlWriter.end();
        xmlWriter.start("Nodes");
        Map<String, MediaWorkflowNode> map2 = mediaWorkflowRequest.getTopology().getMediaWorkflowNodes();
        for (String string : map2.keySet()) {
            xmlWriter.start(string);
            MediaWorkflowNode mediaWorkflowNode = (MediaWorkflowNode)map2.get(string);
            xmlWriter.start("Type").value(mediaWorkflowNode.getType()).end();
            if (mediaWorkflowNode.getInput().getObjectPrefix() != null || mediaWorkflowNode.getInput().getQueueId() != null) {
                xmlWriter.start("Input");
                RequestXmlFactory.addIfNotNull(xmlWriter, "QueueId", mediaWorkflowNode.getInput().getQueueId());
                RequestXmlFactory.addIfNotNull(xmlWriter, "ObjectPrefix", mediaWorkflowNode.getInput().getObjectPrefix());
                xmlWriter.end();
            }
            MediaOperation mediaOperation = mediaWorkflowNode.getOperation();
            MediaOutputObject mediaOutputObject = mediaOperation.getOutput();
            if (mediaOperation.getTemplateId() != null || mediaOutputObject.getBucket() != null || mediaOutputObject.getObject() != null || mediaOutputObject.getRegion() != null) {
                xmlWriter.start("Operation");
                RequestXmlFactory.addIfNotNull(xmlWriter, "TemplateId", mediaOperation.getTemplateId());
                xmlWriter.start("Output");
                RequestXmlFactory.addIfNotNull(xmlWriter, "Region", mediaOutputObject.getRegion());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Bucket", mediaOutputObject.getBucket());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Object", mediaOutputObject.getObject());
                xmlWriter.end();
                xmlWriter.end();
            }
            xmlWriter.end();
        }
        xmlWriter.end();
        xmlWriter.end();
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaJobsRequest mediaJobsRequest) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        MediaConcatTemplateObject mediaConcatTemplateObject;
        Object object6;
        Object object7;
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Tag").value(mediaJobsRequest.getTag()).end();
        xmlWriter.start("BucketName").value(mediaJobsRequest.getBucketName()).end();
        xmlWriter.start("Input");
        xmlWriter.start("Object").value(mediaJobsRequest.getInput().getObject()).end();
        xmlWriter.end();
        MediaJobOperation mediaJobOperation = mediaJobsRequest.getOperation();
        xmlWriter.start("Operation");
        RequestXmlFactory.addIfNotNull(xmlWriter, "TemplateId", mediaJobOperation.getTemplateId());
        List<String> list = mediaJobOperation.getWatermarkTemplateId();
        if (list.size() != 0) {
            object7 = list.iterator();
            while (object7.hasNext()) {
                object6 = (String)object7.next();
                xmlWriter.start("WatermarkTemplateId").value((String)object6).end();
            }
        }
        if (CheckObjectUtils.objIsNotValid(object7 = mediaJobOperation.getWatermark()).booleanValue()) {
            RequestXmlFactory.addIfNotNull(xmlWriter, "Type", ((MediaWatermark)object7).getType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dx", ((MediaWatermark)object7).getDx());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dy", ((MediaWatermark)object7).getDy());
            RequestXmlFactory.addIfNotNull(xmlWriter, "EndTime", ((MediaWatermark)object7).getEndTime());
            RequestXmlFactory.addIfNotNull(xmlWriter, "LocMode", ((MediaWatermark)object7).getLocMode());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Pos", ((MediaWatermark)object7).getPos());
            RequestXmlFactory.addIfNotNull(xmlWriter, "StartTime", ((MediaWatermark)object7).getStartTime());
            if ("Text".equalsIgnoreCase(((MediaWatermark)object7).getType())) {
                object6 = ((MediaWatermark)object7).getText();
                xmlWriter.start("Text");
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontColor", ((MediaWaterMarkText)object6).getFontColor());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontSize", ((MediaWaterMarkText)object6).getFontSize());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontType", ((MediaWaterMarkText)object6).getFontType());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Text", ((MediaWaterMarkText)object6).getText());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Transparency", ((MediaWaterMarkText)object6).getTransparency());
                xmlWriter.end();
            } else if ("Image".equalsIgnoreCase(((MediaWatermark)object7).getType())) {
                object6 = ((MediaWatermark)object7).getImage();
                xmlWriter.start("Image");
                RequestXmlFactory.addIfNotNull(xmlWriter, "Height", ((MediaWaterMarkImage)object6).getHeight());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", ((MediaWaterMarkImage)object6).getMode());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Transparency", ((MediaWaterMarkImage)object6).getTransparency());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Url", ((MediaWaterMarkImage)object6).getUrl());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Width", ((MediaWaterMarkImage)object6).getWidth());
                xmlWriter.end();
            }
        }
        if (CheckObjectUtils.objIsNotValid(object6 = mediaJobOperation.getRemoveWatermark()).booleanValue()) {
            xmlWriter.start("RemoveWatermark");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Height", ((MediaRemoveWaterMark)object6).getHeight());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dx", ((MediaRemoveWaterMark)object6).getDx());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dy", ((MediaRemoveWaterMark)object6).getDy());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Switch", ((MediaRemoveWaterMark)object6).get_switch());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Width", ((MediaRemoveWaterMark)object6).getWidth());
            xmlWriter.end();
        }
        if (CheckObjectUtils.objIsNotValid(mediaConcatTemplateObject = mediaJobOperation.getMediaConcatTemplate()).booleanValue()) {
            xmlWriter.start("ConcatTemplate");
            object5 = mediaConcatTemplateObject.getConcatFragmentList();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (MediaConcatFragmentObject)object4.next();
                xmlWriter.start("ConcatFragment");
                RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", ((MediaConcatFragmentObject)object3).getMode());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Url", ((MediaConcatFragmentObject)object3).getUrl());
                xmlWriter.end();
            }
            RequestXmlFactory.addVideo(xmlWriter, mediaConcatTemplateObject.getVideo());
            RequestXmlFactory.addAudio(xmlWriter, mediaConcatTemplateObject.getAudio());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Index", mediaConcatTemplateObject.getIndex());
            object4 = mediaConcatTemplateObject.getContainer().getFormat();
            if (!StringUtils.isNullOrEmpty((String)object4)) {
                xmlWriter.start("Container");
                xmlWriter.start("Format").value((String)object4).end();
                xmlWriter.end();
            }
            xmlWriter.end();
        }
        object5 = mediaJobOperation.getTranscode();
        object4 = ((MediaTranscodeObject)object5).getContainer().getFormat();
        if (CheckObjectUtils.objIsNotValid(object5).booleanValue() && !StringUtils.isNullOrEmpty((String)object4)) {
            xmlWriter.start("Transcode");
            object3 = ((MediaTranscodeObject)object5).getVideo();
            object2 = ((MediaTranscodeObject)object5).getAudio();
            object = ((MediaTranscodeObject)object5).getTransConfig();
            MediaTimeIntervalObject mediaTimeIntervalObject = ((MediaTranscodeObject)object5).getTimeInterval();
            if (object4 != null) {
                xmlWriter.start("Container");
                xmlWriter.start("Format").value((String)object4).end();
                xmlWriter.end();
            }
            if (CheckObjectUtils.objIsNotValid(mediaTimeIntervalObject).booleanValue()) {
                xmlWriter.start("TimeInterval");
                xmlWriter.start("Duration").value(mediaTimeIntervalObject.getDuration()).end();
                xmlWriter.start("Start").value(mediaTimeIntervalObject.getStart()).end();
                xmlWriter.end();
            }
            if (CheckObjectUtils.objIsNotValid(object3).booleanValue()) {
                RequestXmlFactory.addVideo(xmlWriter, (MediaTranscodeVideoObject)object3);
            }
            if (CheckObjectUtils.objIsNotValid(object2).booleanValue()) {
                RequestXmlFactory.addAudio(xmlWriter, (MediaAudioObject)object2);
            }
            if (CheckObjectUtils.objIsNotValid(object).booleanValue()) {
                xmlWriter.start("TransConfig");
                RequestXmlFactory.addIfNotNull(xmlWriter, "AdjDarMethod", ((MediaTransConfigObject)object).getAdjDarMethod());
                RequestXmlFactory.addIfNotNull(xmlWriter, "AudioBitrateAdjMethod", ((MediaTransConfigObject)object).getAudioBitrateAdjMethod());
                RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckAudioBitrate", ((MediaTransConfigObject)object).getIsCheckAudioBitrate());
                RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckReso", ((MediaTransConfigObject)object).getIsCheckReso());
                RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckVideoBitrate", ((MediaTransConfigObject)object).getIsCheckVideoBitrate());
                RequestXmlFactory.addIfNotNull(xmlWriter, "ResoAdjMethod", ((MediaTransConfigObject)object).getResoAdjMethod());
                RequestXmlFactory.addIfNotNull(xmlWriter, "TransMode", ((MediaTransConfigObject)object).getTransMode());
                RequestXmlFactory.addIfNotNull(xmlWriter, "VideoBitrateAdjMethod", ((MediaTransConfigObject)object).getVideoBitrateAdjMethod());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
        if (CheckObjectUtils.objIsNotValid(object3 = mediaJobOperation.getDigitalWatermark()).booleanValue()) {
            xmlWriter.start("DigitalWatermark");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Message", ((MediaDigitalWatermark)object3).getMessage());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Type", ((MediaDigitalWatermark)object3).getType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Version", ((MediaDigitalWatermark)object3).getVersion());
            xmlWriter.end();
        }
        if (((MediaDigitalWatermark)(object2 = mediaJobOperation.getExtractDigitalWatermark())).getType() != null || ((MediaDigitalWatermark)object2).getMessage() != null) {
            xmlWriter.start("ExtractDigitalWatermark");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Message", ((MediaDigitalWatermark)object2).getMessage());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Type", ((MediaDigitalWatermark)object2).getType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Version", ((MediaDigitalWatermark)object2).getVersion());
            xmlWriter.end();
        }
        if (CheckObjectUtils.objIsNotValid(object = mediaJobOperation.getOutput()).booleanValue()) {
            xmlWriter.start("Output");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Region", ((MediaOutputObject)object).getRegion());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Object", ((MediaOutputObject)object).getObject());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Bucket", ((MediaOutputObject)object).getBucket());
            xmlWriter.end();
        }
        xmlWriter.end();
        xmlWriter.start("QueueId").value(mediaJobsRequest.getQueueId()).end();
        RequestXmlFactory.addIfNotNull(xmlWriter, "CallBack", mediaJobsRequest.getCallBack());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaQueueRequest mediaQueueRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Name").value(mediaQueueRequest.getName()).end();
        xmlWriter.start("QueueId").value(mediaQueueRequest.getQueueId()).end();
        xmlWriter.start("State").value(mediaQueueRequest.getState()).end();
        xmlWriter.start("NotifyConfig");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Type", mediaQueueRequest.getNotifyConfig().getType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", mediaQueueRequest.getNotifyConfig().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Event", mediaQueueRequest.getNotifyConfig().getEvent());
        RequestXmlFactory.addIfNotNull(xmlWriter, "State", mediaQueueRequest.getNotifyConfig().getState());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(SnapshotRequest snapshotRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        xmlWriter.start("Object").value(snapshotRequest.getInput().getObject()).end();
        xmlWriter.end();
        xmlWriter.start("Output");
        xmlWriter.start("Region").value(snapshotRequest.getOutput().getRegion()).end();
        xmlWriter.start("Object").value(snapshotRequest.getOutput().getObject()).end();
        xmlWriter.start("Bucket").value(snapshotRequest.getOutput().getBucket()).end();
        xmlWriter.end();
        RequestXmlFactory.addIfNotNull(xmlWriter, "Time", snapshotRequest.getTime());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Format", snapshotRequest.getFormat());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Height", snapshotRequest.getHeight());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", snapshotRequest.getMode());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Rotate", snapshotRequest.getRotate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Width", snapshotRequest.getWidth());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaTemplateRequest mediaTemplateRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        String string = mediaTemplateRequest.getTag();
        xmlWriter.start("Request");
        xmlWriter.start("Tag").value(string).end();
        xmlWriter.start("Name").value(mediaTemplateRequest.getName()).end();
        if ("Animation".equalsIgnoreCase(string)) {
            xmlWriter.start("Container");
            xmlWriter.start("Format").value(mediaTemplateRequest.getContainer().getFormat()).end();
            xmlWriter.end();
            RequestXmlFactory.addVideo(xmlWriter, mediaTemplateRequest);
            if (CheckObjectUtils.objIsNotValid(mediaTemplateRequest.getTimeInterval()).booleanValue()) {
                xmlWriter.start("TimeInterval");
                xmlWriter.start("Duration").value(mediaTemplateRequest.getTimeInterval().getDuration()).end();
                xmlWriter.start("Start").value(mediaTemplateRequest.getTimeInterval().getStart()).end();
                xmlWriter.end();
            }
        } else if ("Snapshot".equalsIgnoreCase(string)) {
            if (CheckObjectUtils.objIsNotValid(mediaTemplateRequest.getSnapshot()).booleanValue()) {
                xmlWriter.start("Snapshot");
                MediaSnapshotObject mediaSnapshotObject = mediaTemplateRequest.getSnapshot();
                RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaSnapshotObject.getMode());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Count", mediaSnapshotObject.getCount());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaSnapshotObject.getFps());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Height", mediaSnapshotObject.getHeight());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Start", mediaSnapshotObject.getStart());
                RequestXmlFactory.addIfNotNull(xmlWriter, "TimeInterval", mediaSnapshotObject.getTimeInterval());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Width", mediaSnapshotObject.getWidth());
                xmlWriter.end();
            }
        } else if ("Watermark".equalsIgnoreCase(string)) {
            xmlWriter.start("Watermark");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Type", mediaTemplateRequest.getWatermark().getType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dx", mediaTemplateRequest.getWatermark().getDx());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Dy", mediaTemplateRequest.getWatermark().getDy());
            RequestXmlFactory.addIfNotNull(xmlWriter, "EndTime", mediaTemplateRequest.getWatermark().getEndTime());
            RequestXmlFactory.addIfNotNull(xmlWriter, "LocMode", mediaTemplateRequest.getWatermark().getLocMode());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Pos", mediaTemplateRequest.getWatermark().getPos());
            RequestXmlFactory.addIfNotNull(xmlWriter, "StartTime", mediaTemplateRequest.getWatermark().getStartTime());
            if ("Text".equalsIgnoreCase(mediaTemplateRequest.getWatermark().getType())) {
                xmlWriter.start("Text");
                MediaWaterMarkText mediaWaterMarkText = mediaTemplateRequest.getWatermark().getText();
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontColor", mediaWaterMarkText.getFontColor());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontSize", mediaWaterMarkText.getFontSize());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FontType", mediaWaterMarkText.getFontType());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Text", mediaWaterMarkText.getText());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkText.getTransparency());
                xmlWriter.end();
            } else if ("Image".equalsIgnoreCase(mediaTemplateRequest.getWatermark().getType())) {
                xmlWriter.start("Image");
                MediaWaterMarkImage mediaWaterMarkImage = mediaTemplateRequest.getWatermark().getImage();
                RequestXmlFactory.addIfNotNull(xmlWriter, "Height", mediaWaterMarkImage.getHeight());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", mediaWaterMarkImage.getMode());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Url", mediaWaterMarkImage.getUrl());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Transparency", mediaWaterMarkImage.getTransparency());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Width", mediaWaterMarkImage.getWidth());
                xmlWriter.end();
            }
            xmlWriter.end();
        } else if ("Transcode".equalsIgnoreCase(string)) {
            xmlWriter.start("Container");
            xmlWriter.start("Format").value(mediaTemplateRequest.getContainer().getFormat()).end();
            xmlWriter.end();
            xmlWriter.start("TimeInterval");
            xmlWriter.start("Duration").value(mediaTemplateRequest.getTimeInterval().getDuration()).end();
            xmlWriter.start("Start").value(mediaTemplateRequest.getTimeInterval().getStart()).end();
            xmlWriter.end();
            RequestXmlFactory.addAudio(xmlWriter, mediaTemplateRequest.getAudio());
            xmlWriter.start("TransConfig");
            RequestXmlFactory.addIfNotNull(xmlWriter, "AdjDarMethod", mediaTemplateRequest.getTransConfig().getAdjDarMethod());
            RequestXmlFactory.addIfNotNull(xmlWriter, "AudioBitrateAdjMethod", mediaTemplateRequest.getTransConfig().getAudioBitrateAdjMethod());
            RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckAudioBitrate", mediaTemplateRequest.getTransConfig().getIsCheckAudioBitrate());
            RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckReso", mediaTemplateRequest.getTransConfig().getIsCheckReso());
            RequestXmlFactory.addIfNotNull(xmlWriter, "IsCheckVideoBitrate", mediaTemplateRequest.getTransConfig().getIsCheckVideoBitrate());
            RequestXmlFactory.addIfNotNull(xmlWriter, "ResoAdjMethod", mediaTemplateRequest.getTransConfig().getResoAdjMethod());
            RequestXmlFactory.addIfNotNull(xmlWriter, "TransMode", mediaTemplateRequest.getTransConfig().getTransMode());
            RequestXmlFactory.addIfNotNull(xmlWriter, "VideoBitrateAdjMethod", mediaTemplateRequest.getTransConfig().getVideoBitrateAdjMethod());
            xmlWriter.end();
            RequestXmlFactory.addVideo(xmlWriter, mediaTemplateRequest);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addAudio(XmlWriter xmlWriter, MediaAudioObject mediaAudioObject) {
        if (CheckObjectUtils.objIsValid(mediaAudioObject).booleanValue()) {
            return;
        }
        xmlWriter.start("Audio");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaAudioObject.getBitrate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Channels", mediaAudioObject.getChannels());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaAudioObject.getCodec());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaAudioObject.getProfile());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaAudioObject.getRemove());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Samplerate", mediaAudioObject.getSamplerate());
        xmlWriter.end();
    }

    public static byte[] convertToXmlByteArray(MediaInfoRequest mediaInfoRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        xmlWriter.start("Object").value(mediaInfoRequest.getInput().getObject()).end();
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocJobRequest docJobRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        DocJobObject docJobObject = docJobRequest.getDocJobObject();
        xmlWriter.start("Request");
        xmlWriter.start("Tag").value(docJobObject.getTag()).end();
        xmlWriter.start("QueueId").value(docJobObject.getQueueId()).end();
        xmlWriter.start("Input");
        xmlWriter.start("Object").value(docJobObject.getInput().getObject()).end();
        xmlWriter.end();
        if (CheckObjectUtils.objIsNotValid(docJobObject).booleanValue()) {
            xmlWriter.start("Operation");
            xmlWriter.start("Output");
            MediaOutputObject mediaOutputObject = docJobObject.getOperation().getOutput();
            RequestXmlFactory.addIfNotNull(xmlWriter, "Region", mediaOutputObject.getRegion());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Bucket", mediaOutputObject.getBucket());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Object", mediaOutputObject.getObject());
            xmlWriter.end();
            xmlWriter.start("DocProcess");
            DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
            RequestXmlFactory.addIfNotNull(xmlWriter, "SrcType", docProcessObject.getSrcType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "TgtType", docProcessObject.getTgtType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "SheetId", docProcessObject.getSheetId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "StartPage", docProcessObject.getStartPage());
            RequestXmlFactory.addIfNotNull(xmlWriter, "EndPage", docProcessObject.getEndPage());
            RequestXmlFactory.addIfNotNull(xmlWriter, "ImageParams", docProcessObject.getImageParams());
            RequestXmlFactory.addIfNotNull(xmlWriter, "DocPassword", docProcessObject.getDocPassword());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Comments", docProcessObject.getComments());
            RequestXmlFactory.addIfNotNull(xmlWriter, "PaperDirection", docProcessObject.getPaperDirection());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Quality", docProcessObject.getQuality());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Zoom", docProcessObject.getZoom());
            RequestXmlFactory.addIfNotNull(xmlWriter, "PicPagination", docProcessObject.getPicPagination());
            RequestXmlFactory.addIfNotNull(xmlWriter, "ImageDpi", docProcessObject.getImageDpi());
            xmlWriter.end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocQueueRequest docQueueRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Name").value(docQueueRequest.getName()).end();
        xmlWriter.start("QueueId").value(docQueueRequest.getQueueId()).end();
        xmlWriter.start("State").value(docQueueRequest.getState()).end();
        xmlWriter.start("NotifyConfig");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Type", docQueueRequest.getNotifyConfig().getType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", docQueueRequest.getNotifyConfig().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Event", docQueueRequest.getNotifyConfig().getEvent());
        RequestXmlFactory.addIfNotNull(xmlWriter, "State", docQueueRequest.getNotifyConfig().getState());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(VideoAuditingRequest videoAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Object", videoAuditingRequest.getInput().getObject());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", videoAuditingRequest.getInput().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "DataId", videoAuditingRequest.getInput().getDataId());
        RequestXmlFactory.addUserInfo(xmlWriter, videoAuditingRequest.getInput().getUserInfo());
        xmlWriter.end();
        Conf conf = videoAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "DetectContent", conf.getDetectContent());
        RequestXmlFactory.addIfNotNull(xmlWriter, "CallbackVersion", (Object)conf.getCallbackVersion());
        xmlWriter.start("Snapshot");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Mode", conf.getSnapshot().getMode());
        RequestXmlFactory.addIfNotNull(xmlWriter, "TimeInterval", conf.getSnapshot().getTimeInterval());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Count", conf.getSnapshot().getCount());
        xmlWriter.end();
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(AudioAuditingRequest audioAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Object", audioAuditingRequest.getInput().getObject());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", audioAuditingRequest.getInput().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "DataId", audioAuditingRequest.getInput().getDataId());
        RequestXmlFactory.addUserInfo(xmlWriter, audioAuditingRequest.getInput().getUserInfo());
        xmlWriter.end();
        Conf conf = audioAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        RequestXmlFactory.addIfNotNull(xmlWriter, "CallbackVersion", (Object)conf.getCallbackVersion());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(TextAuditingRequest textAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Object", textAuditingRequest.getInput().getObject());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Content", textAuditingRequest.getInput().getContent());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", textAuditingRequest.getInput().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "DataId", textAuditingRequest.getInput().getDataId());
        RequestXmlFactory.addUserInfo(xmlWriter, textAuditingRequest.getInput().getUserInfo());
        xmlWriter.end();
        Conf conf = textAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "CallbackVersion", (Object)conf.getCallbackVersion());
        RequestXmlFactory.addIfNotNull(xmlWriter, "CallbackType", conf.getCallbackType());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocumentAuditingRequest documentAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", documentAuditingRequest.getInput().getUrl());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Object", documentAuditingRequest.getInput().getObject());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Type", documentAuditingRequest.getInput().getType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "DataId", documentAuditingRequest.getInput().getDataId());
        RequestXmlFactory.addUserInfo(xmlWriter, documentAuditingRequest.getInput().getUserInfo());
        xmlWriter.end();
        Conf conf = documentAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(WebpageAuditingRequest webpageAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        xmlWriter.start("Input");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Url", webpageAuditingRequest.getInput().getUrl());
        xmlWriter.end();
        Conf conf = webpageAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ReturnHighlightHtml", conf.getReturnHighlightHtml());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(BatchImageAuditingRequest batchImageAuditingRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Request");
        List<BatchImageAuditingInputObject> list = batchImageAuditingRequest.getInputList();
        for (BatchImageAuditingInputObject object2 : list) {
            xmlWriter.start("Input");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Url", object2.getUrl());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Object", object2.getObject());
            RequestXmlFactory.addIfNotNull(xmlWriter, "DataId", object2.getDataId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "MaxFrames", object2.getMaxFrames());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Interval", object2.getInterval());
            RequestXmlFactory.addIfNotNull(xmlWriter, "LargeImageDetect", object2.getLargeImageDetect());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Content", object2.getContent());
            RequestXmlFactory.addUserInfo(xmlWriter, object2.getUserInfo());
            xmlWriter.end();
        }
        Conf conf = batchImageAuditingRequest.getConf();
        xmlWriter.start("Conf");
        String string = conf.getDetectType();
        RequestXmlFactory.addAuditingDetectType(xmlWriter, string);
        RequestXmlFactory.addIfNotNull(xmlWriter, "BizType", conf.getBizType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Async", conf.getAsync());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Callback", conf.getCallback());
        xmlWriter.end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addIfNotNull(XmlWriter xmlWriter, String string, String string2) {
        if (string2 != null) {
            xmlWriter.start(string).value(string2).end();
        }
    }

    private static void addIfNotNull(XmlWriter xmlWriter, String string, Object object) {
        if (object != null && object.toString() != null) {
            xmlWriter.start(string).value(object.toString()).end();
        }
    }

    private static void addVideo(XmlWriter xmlWriter, MediaTemplateRequest mediaTemplateRequest) {
        MediaVideoObject mediaVideoObject = mediaTemplateRequest.getVideo();
        RequestXmlFactory.addVideo(xmlWriter, mediaVideoObject);
    }

    private static void addVideo(XmlWriter xmlWriter, MediaVideoObject mediaVideoObject) {
        if (CheckObjectUtils.objIsValid(mediaVideoObject).booleanValue()) {
            return;
        }
        xmlWriter.start("Video");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaVideoObject.getCodec());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Width", mediaVideoObject.getWidth());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Height", mediaVideoObject.getHeight());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaVideoObject.getFps());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaVideoObject.getBitrate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BufSize", mediaVideoObject.getBufSize());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Crf", mediaVideoObject.getCrf());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Crop", mediaVideoObject.getCrop());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Gop", mediaVideoObject.getGop());
        RequestXmlFactory.addIfNotNull(xmlWriter, "LongShortMode", mediaVideoObject.getLongShortMode());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Maxrate", mediaVideoObject.getMaxrate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Pad", mediaVideoObject.getPad());
        RequestXmlFactory.addIfNotNull(xmlWriter, "PixFmt", mediaVideoObject.getPixFmt());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Preset", mediaVideoObject.getPreset());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaVideoObject.getProfile());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Qality", mediaVideoObject.getQality());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Quality", mediaVideoObject.getQuality());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaVideoObject.getRemove());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ScanMode", mediaVideoObject.getScanMode());
        RequestXmlFactory.addIfNotNull(xmlWriter, "HlsTsTime", mediaVideoObject.getHlsTsTime());
        RequestXmlFactory.addIfNotNull(xmlWriter, "AnimateFramesPerSecond", mediaVideoObject.getAnimateFramesPerSecond());
        RequestXmlFactory.addIfNotNull(xmlWriter, "AnimateTimeIntervalOfFrame", mediaVideoObject.getAnimateTimeIntervalOfFrame());
        RequestXmlFactory.addIfNotNull(xmlWriter, "AnimateOnlyKeepKeyFrame", mediaVideoObject.getAnimateOnlyKeepKeyFrame());
        xmlWriter.end();
    }

    private static void addVideo(XmlWriter xmlWriter, MediaTranscodeVideoObject mediaTranscodeVideoObject) {
        if (CheckObjectUtils.objIsValid(mediaTranscodeVideoObject).booleanValue()) {
            return;
        }
        xmlWriter.start("Video");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Codec", mediaTranscodeVideoObject.getCodec());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Width", mediaTranscodeVideoObject.getWidth());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Height", mediaTranscodeVideoObject.getHeight());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Fps", mediaTranscodeVideoObject.getFps());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Bitrate", mediaTranscodeVideoObject.getBitrate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "BufSize", mediaTranscodeVideoObject.getBufSize());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Crf", mediaTranscodeVideoObject.getCrf());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Gop", mediaTranscodeVideoObject.getGop());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Maxrate", mediaTranscodeVideoObject.getMaxrate());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Preset", mediaTranscodeVideoObject.getPreset());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Profile", mediaTranscodeVideoObject.getProfile());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Remove", mediaTranscodeVideoObject.getRemove());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ScanMode", mediaTranscodeVideoObject.getScanMode());
        xmlWriter.end();
    }

    private static void addUserInfo(XmlWriter xmlWriter, UserInfo userInfo) {
        if (CheckObjectUtils.objIsNotValid(userInfo).booleanValue()) {
            xmlWriter.start("UserInfo");
            RequestXmlFactory.addIfNotNull(xmlWriter, "TokenId", userInfo.getTokenId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Nickname", userInfo.getNickname());
            RequestXmlFactory.addIfNotNull(xmlWriter, "DeviceId", userInfo.getDeviceId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "AppId", userInfo.getAppId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Room", userInfo.getRoom());
            RequestXmlFactory.addIfNotNull(xmlWriter, "IP", userInfo.getIp());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Type", userInfo.getType());
            RequestXmlFactory.addIfNotNull(xmlWriter, "ReceiveTokenId", userInfo.getReceiveTokenId());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Gender", userInfo.getGender());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Level", userInfo.getLevel());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Role", userInfo.getRole());
            xmlWriter.end();
        }
    }

    private static void addAuditingDetectType(XmlWriter xmlWriter, String string) {
        if (!"all".equalsIgnoreCase(string)) {
            RequestXmlFactory.addIfNotNull(xmlWriter, "DetectType", string);
        }
    }

    public static class CheckObjectUtils {
        public static Boolean objIsNotValid(Object object) {
            Field[] fieldArray;
            for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object object2 = field.get(object);
                    if (CheckObjectUtils.isValid(object2)) continue;
                    return true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            return false;
        }

        public static Boolean objIsValid(Object object) {
            return CheckObjectUtils.objIsNotValid(object) == false;
        }

        public static boolean isValid(Object object) {
            return object == null || CheckObjectUtils.isValid(object.toString());
        }

        public static boolean isValid(String string) {
            return string == null || "".equals(string.trim()) || "null".equalsIgnoreCase(string);
        }
    }
}

