/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.ObjectRestoreResult;
import com.qcloud.cos.utils.DateUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRestoreHeaderHandler<T extends ObjectRestoreResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern ongoingPattern = Pattern.compile("ongoing-request=\"(.*?)\"");
    private static final Logger log = LoggerFactory.getLogger(ObjectRestoreHeaderHandler.class);

    @Override
    public void handle(T t2, CosHttpResponse cosHttpResponse) {
        String string = cosHttpResponse.getHeaders().get("x-cos-restore");
        if (string != null) {
            t2.setRestoreExpirationTime(this.parseDate(string));
            Boolean bl = this.parseBoolean(string);
            if (bl != null) {
                t2.setOngoingRestore(bl);
            }
        }
    }

    private Date parseDate(String string) {
        Matcher matcher = datePattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return DateUtils.parseRFC822Date(string2);
            }
            catch (Exception exception) {
                log.warn("Error parsing expiry-date from x-cos-restore header.", exception);
            }
        }
        return null;
    }

    private Boolean parseBoolean(String string) {
        Matcher matcher = ongoingPattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return Boolean.parseBoolean(string2);
        }
        return null;
    }
}

