/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.utils.DateUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectExpirationHeaderHandler<T extends ObjectExpirationResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern rulePattern = Pattern.compile("rule-id=\"(.*?)\"");
    private static final Logger log = LoggerFactory.getLogger(ObjectExpirationHeaderHandler.class);

    @Override
    public void handle(T t2, CosHttpResponse cosHttpResponse) {
        String string = cosHttpResponse.getHeaders().get("x-cos-expiration");
        if (string != null) {
            t2.setExpirationTime(this.parseDate(string));
            t2.setExpirationTimeRuleId(this.parseRuleId(string));
        }
    }

    private String parseRuleId(String string) {
        Matcher matcher = rulePattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Date parseDate(String string) {
        Matcher matcher = datePattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return DateUtils.parseRFC822Date(string2);
            }
            catch (Exception exception) {
                log.warn("Error parsing expiry-date from x-cos-expiration header.", exception);
            }
        }
        return null;
    }
}

