/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.SdkDigestInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigestValidationInputStream
extends SdkDigestInputStream {
    private byte[] expectedHash;
    private boolean digestValidated = false;

    public DigestValidationInputStream(InputStream inputStream2, MessageDigest messageDigest, byte[] byArray) {
        super(inputStream2, messageDigest);
        this.expectedHash = byArray;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.validateDigest();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.validateDigest();
        }
        return n3;
    }

    public byte[] getDigestChecksum() {
        return this.digest.digest();
    }

    private void validateDigest() {
        if (this.expectedHash != null && !this.digestValidated) {
            this.digestValidated = true;
            if (!Arrays.equals(this.digest.digest(), this.expectedHash)) {
                throw new CosClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Qcloud COS.  The data may be corrupt.");
            }
        }
    }
}

