/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.event.ProgressInputStream;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.ResponseNotCompleteException;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.http.IdleConnectionMonitorThread;
import com.qcloud.cos.internal.CosErrorResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkBufferedInputStream;
import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.retry.RetryPolicy;
import com.qcloud.cos.utils.CodecUtils;
import com.qcloud.cos.utils.ExceptionUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import com.qcloud.cos.utils.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
implements CosHttpClient {
    private ClientConfig clientConfig;
    private RequestConfig requestConfig;
    private HttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitor;
    private int maxErrorRetry;
    private RetryPolicy retryPolicy;
    private BackoffStrategy backoffStrategy;
    private CosErrorResponseHandler errorResponseHandler = new CosErrorResponseHandler();
    private static final Logger log = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.maxErrorRetry = clientConfig.getMaxErrorRetry();
        this.retryPolicy = ValidationUtils.assertNotNull(clientConfig.getRetryPolicy(), "retry policy");
        this.backoffStrategy = ValidationUtils.assertNotNull(clientConfig.getBackoffStrategy(), "backoff strategy");
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setValidateAfterInactivity(1);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.connectionManager);
        if (this.clientConfig.getHttpProxyIp() != null && this.clientConfig.getHttpProxyPort() != 0) {
            HttpHost httpHost = new HttpHost(this.clientConfig.getHttpProxyIp(), this.clientConfig.getHttpProxyPort());
            httpClientBuilder.setProxy(httpHost);
        }
        this.httpClient = httpClientBuilder.build();
        this.requestConfig = RequestConfig.custom().setContentCompressionEnabled(false).setConnectionRequestTimeout(this.clientConfig.getConnectionRequestTimeout()).setConnectTimeout(this.clientConfig.getConnectionTimeout()).setSocketTimeout(this.clientConfig.getSocketTimeout()).build();
        this.idleConnectionMonitor = new IdleConnectionMonitorThread(this.connectionManager);
        this.idleConnectionMonitor.setIdleAliveMS(this.clientConfig.getIdleConnectionAlive());
        this.idleConnectionMonitor.setDaemon(true);
        this.idleConnectionMonitor.start();
    }

    @Override
    public void shutdown() {
        this.idleConnectionMonitor.shutdown();
    }

    private <X extends CosServiceRequest> URI buildUri(CosHttpRequest<X> cosHttpRequest) {
        Object object;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cosHttpRequest.getProtocol().toString()).append("://").append(cosHttpRequest.getEndpoint());
        String string2 = UrlEncoderUtils.encodeUrlPath(cosHttpRequest.getResourcePath());
        stringBuffer.append(string2);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(cosHttpRequest.getParameters());
        Map<String, List<String>> map = ((CosServiceRequest)cosHttpRequest.getOriginalRequest()).getCustomQueryParameters();
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                string = entry.getKey();
                object = entry.getValue();
                int n = object.size();
                for (int i = 0; i < n; ++i) {
                    hashMap.put(string, object.get(i));
                }
            }
        }
        for (Map.Entry<String, List<String>> entry : hashMap.entrySet()) {
            string = entry.getKey();
            if (string == null) continue;
            if (bl) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append(UrlEncoderUtils.encode(string));
            if (!bl) {
                bl = true;
            }
            if ((object = (String)((Object)entry.getValue())) == null) continue;
            stringBuffer2.append("=");
            stringBuffer2.append(UrlEncoderUtils.encode((String)object));
        }
        String string3 = stringBuffer2.toString();
        if (!string3.isEmpty()) {
            stringBuffer.append("?").append(string3);
            if (cosHttpRequest.getCiSpecialEndParameter() != null) {
                stringBuffer.append("&").append(cosHttpRequest.getCiSpecialEndParameter());
            }
        } else if (cosHttpRequest.getCiSpecialEndParameter() != null) {
            stringBuffer.append("?").append(cosHttpRequest.getCiSpecialEndParameter());
        }
        try {
            URI uRI = new URI(stringBuffer.toString());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CosClientException("build uri error! url: " + stringBuffer.toString() + ", CosHttpRequest: " + cosHttpRequest.toString(), uRISyntaxException);
        }
    }

    private <X extends CosServiceRequest> HttpRequestBase buildHttpRequest(CosHttpRequest<X> cosHttpRequest) throws CosClientException {
        String string;
        HttpRequestBase httpRequestBase = null;
        HttpMethodName httpMethodName = cosHttpRequest.getHttpMethod();
        if (httpMethodName.equals((Object)HttpMethodName.PUT)) {
            httpRequestBase = new HttpPut();
        } else if (httpMethodName.equals((Object)HttpMethodName.GET)) {
            httpRequestBase = new HttpGet();
        } else if (httpMethodName.equals((Object)HttpMethodName.DELETE)) {
            httpRequestBase = new HttpDelete();
        } else if (httpMethodName.equals((Object)HttpMethodName.POST)) {
            httpRequestBase = new HttpPost();
        } else if (httpMethodName.equals((Object)HttpMethodName.HEAD)) {
            httpRequestBase = new HttpHead();
        } else {
            throw new CosClientException("unsupported http method " + (Object)((Object)httpMethodName));
        }
        httpRequestBase.setURI(this.buildUri(cosHttpRequest));
        long l = -1L;
        Map<String, String> map = cosHttpRequest.getHeaders();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string2 = object2.getKey();
            string = object2.getValue();
            if (string2.equals("Content-Length")) {
                l = Long.parseLong(string);
                continue;
            }
            string = CodecUtils.convertFromUtf8ToIso88591(string);
            httpRequestBase.addHeader(string2, string);
        }
        Map<String, String> map2 = ((CosServiceRequest)cosHttpRequest.getOriginalRequest()).getCustomRequestHeaders();
        if (map2 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                string = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                if (string.equals("Content-Length")) {
                    l = Long.parseLong(string3);
                    continue;
                }
                string3 = CodecUtils.convertFromUtf8ToIso88591(string3);
                httpRequestBase.addHeader(string, string3);
            }
        }
        if (log.isDebugEnabled()) {
            httpRequestBase.addHeader("x-cos-sdk-log-debug", "on");
        } else {
            httpRequestBase.addHeader("x-cos-sdk-log-debug", "off");
        }
        if (this.clientConfig.isShortConnection()) {
            httpRequestBase.addHeader("Connection", "close");
        }
        if (cosHttpRequest.getContent() != null) {
            InputStreamEntity inputStreamEntity = new InputStreamEntity(cosHttpRequest.getContent(), l);
            if (httpMethodName.equals((Object)HttpMethodName.PUT) || httpMethodName.equals((Object)HttpMethodName.POST)) {
                HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = (HttpEntityEnclosingRequestBase)httpRequestBase;
                httpEntityEnclosingRequestBase.setEntity(inputStreamEntity);
            }
        }
        httpRequestBase.setConfig(this.requestConfig);
        if (this.clientConfig.useBasicAuth()) {
            this.setBasicProxyAuthorization(httpRequestBase);
        }
        return httpRequestBase;
    }

    private boolean isRequestSuccessful(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = -1;
        if (statusLine != null) {
            n = statusLine.getStatusCode();
        }
        return n / 100 == 2;
    }

    private <X extends CosServiceRequest> CosHttpResponse createResponse(HttpRequestBase httpRequestBase, CosHttpRequest<X> cosHttpRequest, HttpResponse httpResponse) throws IOException {
        ProgressListener progressListener = cosHttpRequest.getProgressListener();
        CosHttpResponse cosHttpResponse = new CosHttpResponse(cosHttpRequest, httpRequestBase);
        if (httpResponse.getEntity() != null) {
            Header[] headerArray = httpResponse.getEntity().getContent();
            InputStream inputStream2 = null;
            if (headerArray != null) {
                inputStream2 = ProgressInputStream.inputStreamForResponse((InputStream)headerArray, progressListener);
                cosHttpResponse.setContent(inputStream2);
            }
        }
        cosHttpResponse.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        cosHttpResponse.setStatusText(httpResponse.getStatusLine().getReasonPhrase());
        for (Header header : httpResponse.getAllHeaders()) {
            String string = CodecUtils.convertFromIso88591ToUtf8(header.getValue());
            cosHttpResponse.addHeader(header.getName(), string);
        }
        return cosHttpResponse;
    }

    private <X extends CosServiceRequest> CosServiceException handlerErrorMessage(CosHttpRequest<X> cosHttpRequest, HttpRequestBase httpRequestBase, HttpResponse httpResponse) throws IOException {
        String string;
        int n;
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine == null) {
            n = -1;
            string = null;
        } else {
            n = statusLine.getStatusCode();
            string = statusLine.getReasonPhrase();
        }
        CosHttpResponse cosHttpResponse = this.createResponse(httpRequestBase, cosHttpRequest, httpResponse);
        CosServiceException cosServiceException = null;
        try {
            cosServiceException = this.errorResponseHandler.handle(cosHttpResponse);
            log.debug("Received error response: " + cosServiceException);
        }
        catch (Exception exception) {
            if (n == 413) {
                cosServiceException = new CosServiceException("Request entity too large");
                cosServiceException.setStatusCode(n);
                cosServiceException.setErrorType(CosServiceException.ErrorType.Client);
                cosServiceException.setErrorCode("Request entity too large");
            }
            if (n == 503 && "Service Unavailable".equalsIgnoreCase(string)) {
                cosServiceException = new CosServiceException("Service unavailable");
                cosServiceException.setStatusCode(n);
                cosServiceException.setErrorType(CosServiceException.ErrorType.Service);
                cosServiceException.setErrorCode("Service unavailable");
            }
            String string2 = "Unable to unmarshall error response (" + exception.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(n)) + ", Response Text: " + string;
            throw new CosClientException(string2, exception);
        }
        cosServiceException.setStatusCode(n);
        cosServiceException.fillInStackTrace();
        return cosServiceException;
    }

    private <X extends CosServiceRequest> void bufferAndResetAbleContent(CosHttpRequest<X> cosHttpRequest) {
        InputStream inputStream2 = cosHttpRequest.getContent();
        if (inputStream2 != null) {
            InputStream inputStream3 = this.buffer(this.makeResettable(inputStream2));
            InputStream inputStream4 = inputStream3 == null ? null : (InputStream)ReleasableInputStream.wrap(inputStream3).disableClose();
            cosHttpRequest.setContent(inputStream4);
        }
    }

    private InputStream monitorStreamProgress(ProgressListener progressListener, InputStream inputStream2) {
        return ProgressInputStream.inputStreamForRequest(inputStream2, progressListener);
    }

    private void setBasicProxyAuthorization(HttpRequestBase httpRequestBase) {
        String string = this.clientConfig.getProxyUsername() + ":" + this.clientConfig.getProxyPassword();
        String string2 = "Basic " + new String(Base64.encodeBase64(string.getBytes()));
        httpRequestBase.addHeader("Proxy-Authorization", string2);
    }

    private <X extends CosServiceRequest> void checkResponse(CosHttpRequest<X> cosHttpRequest, HttpRequestBase httpRequestBase, HttpResponse httpResponse) {
        if (!this.isRequestSuccessful(httpResponse)) {
            try {
                try {
                    throw this.handlerErrorMessage(cosHttpRequest, httpRequestBase, httpResponse);
                }
                catch (IOException iOException) {
                    String string = "Unable to execute HTTP request: " + iOException.getMessage();
                    log.error(string, iOException);
                    CosServiceException cosServiceException = new CosServiceException(string, iOException);
                    throw cosServiceException;
                }
            }
            catch (Throwable throwable) {
                httpRequestBase.abort();
                throw throwable;
            }
        }
    }

    private <X extends CosServiceRequest> boolean isRetryableRequest(CosHttpRequest<X> cosHttpRequest) {
        return cosHttpRequest.getContent() == null || cosHttpRequest.getContent().markSupported();
    }

    private <X extends CosServiceRequest> boolean shouldRetry(CosHttpRequest<X> cosHttpRequest, HttpResponse httpResponse, Exception exception, int n, RetryPolicy retryPolicy) {
        if (n >= this.maxErrorRetry) {
            return false;
        }
        if (!this.isRetryableRequest(cosHttpRequest)) {
            return false;
        }
        return retryPolicy.shouldRetry(cosHttpRequest, httpResponse, exception, n);
    }

    private HttpResponse executeOneRequest(HttpContext httpContext, HttpRequestBase httpRequestBase) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase, httpContext);
        }
        catch (IOException iOException) {
            httpRequestBase.abort();
            throw ExceptionUtils.createClientException(iOException);
        }
        return httpResponse;
    }

    private void closeHttpResponseStream(HttpResponse httpResponse) {
        try {
            if (httpResponse != null && httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException iOException) {
            log.error("exception occur:", iOException);
        }
    }

    @Override
    public <X, Y extends CosServiceRequest> X exeute(CosHttpRequest<Y> cosHttpRequest, HttpResponseHandler<CosServiceResponse<X>> httpResponseHandler) throws CosClientException, CosServiceException {
        String string;
        Object object;
        int n;
        HttpResponse httpResponse = null;
        HttpRequestBase httpRequestBase = null;
        this.bufferAndResetAbleContent(cosHttpRequest);
        ProgressListener progressListener = cosHttpRequest.getProgressListener();
        InputStream inputStream2 = cosHttpRequest.getContent();
        if (inputStream2 != null) {
            cosHttpRequest.setContent(this.monitorStreamProgress(progressListener, inputStream2));
        }
        if (inputStream2 != null && inputStream2.markSupported() && !(inputStream2 instanceof BufferedInputStream)) {
            n = this.clientConfig.getReadLimit();
            inputStream2.mark(n);
        }
        n = 0;
        while (true) {
            try {
                this.checkInterrupted();
                if (inputStream2 instanceof BufferedInputStream && inputStream2.markSupported()) {
                    int n2 = this.clientConfig.getReadLimit();
                    inputStream2.mark(n2);
                }
                if (n != 0 && inputStream2 != null) {
                    inputStream2.reset();
                }
                if (n != 0) {
                    long l = this.backoffStrategy.computeDelayBeforeNextRetry(n);
                    Thread.sleep(l);
                }
                object = HttpClientContext.create();
                httpRequestBase = this.buildHttpRequest(cosHttpRequest);
                httpResponse = null;
                httpResponse = this.executeOneRequest((HttpContext)object, httpRequestBase);
                this.checkResponse(cosHttpRequest, httpRequestBase, httpResponse);
            }
            catch (CosServiceException cosServiceException) {
                if (cosServiceException.getStatusCode() >= 500) {
                    string = String.format("failed to execute http request, due to service exception, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", cosHttpRequest.toString(), n, this.maxErrorRetry);
                    log.error(string, cosServiceException);
                }
                this.closeHttpResponseStream(httpResponse);
                if (this.shouldRetry(cosHttpRequest, httpResponse, cosServiceException, n, this.retryPolicy)) continue;
                throw cosServiceException;
            }
            catch (CosClientException cosClientException) {
                string = String.format("failed to execute http request, due to client exception, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", cosHttpRequest.toString(), n, this.maxErrorRetry);
                log.info(string, cosClientException);
                this.closeHttpResponseStream(httpResponse);
                if (this.shouldRetry(cosHttpRequest, httpResponse, cosClientException, n, this.retryPolicy)) continue;
                log.error(string, cosClientException);
                throw cosClientException;
            }
            catch (Exception exception) {
                string = exception.getClass().getName();
                String string2 = String.format("httpClient execute occur an unknown exception:%s, httpRequest: %s", string, cosHttpRequest);
                this.closeHttpResponseStream(httpResponse);
                log.error(string2, exception);
                throw new CosClientException(string2, exception);
            }
            finally {
                ++n;
                continue;
            }
            break;
        }
        try {
            object = this.createResponse(httpRequestBase, cosHttpRequest, httpResponse);
            string = httpResponseHandler.handle((CosHttpResponse)object).getResult();
            return (X)string;
        }
        catch (Exception exception) {
            if (exception.getMessage().equals("Premature end of chunk coded message body: closing chunk expected")) {
                throw new ResponseNotCompleteException("response chunk not complete", exception);
            }
            string = "Unable to execute response handle: " + exception.getMessage();
            log.info(string, exception);
            CosClientException cosClientException = new CosClientException(string, exception);
            throw cosClientException;
        }
        finally {
            if (!httpResponseHandler.needsConnectionLeftOpen()) {
                httpRequestBase.releaseConnection();
            }
        }
    }

    private InputStream makeResettable(InputStream inputStream2) {
        block3: {
            if (!inputStream2.markSupported() && inputStream2 instanceof FileInputStream) {
                try {
                    return new ResettableInputStream((FileInputStream)inputStream2);
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("For the record; ignore otherwise", iOException);
                }
            }
        }
        return inputStream2;
    }

    private InputStream buffer(InputStream inputStream2) {
        if (!inputStream2.markSupported()) {
            inputStream2 = new SdkBufferedInputStream(inputStream2);
        }
        return inputStream2;
    }

    private void checkInterrupted() throws CosClientException {
        if (Thread.interrupted()) {
            throw new CosClientException("operation has been interrupted!");
        }
    }
}

