/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.RequestProgressInputStream;
import com.qcloud.cos.event.ResponseProgressInputStream;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends SdkFilterInputStream {
    private static final int DEFAULT_NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListener listener;
    private final int notifyThresHold;
    private int unnotifiedByteCount;
    private boolean hasBeenRead;
    private boolean doneEOF;
    private long notifiedByteCount;

    public static InputStream inputStreamForRequest(InputStream inputStream2, ProgressListener progressListener) {
        return progressListener == null ? inputStream2 : new RequestProgressInputStream(inputStream2, progressListener);
    }

    public static InputStream inputStreamForResponse(InputStream inputStream2, CosServiceRequest cosServiceRequest) {
        return cosServiceRequest == null ? inputStream2 : new ResponseProgressInputStream(inputStream2, cosServiceRequest.getGeneralProgressListener());
    }

    public static InputStream inputStreamForResponse(InputStream inputStream2, ProgressListener progressListener) {
        return progressListener == null ? inputStream2 : new ResponseProgressInputStream(inputStream2, progressListener);
    }

    public ProgressInputStream(InputStream inputStream2, ProgressListener progressListener) {
        this(inputStream2, progressListener, 8192);
    }

    public ProgressInputStream(InputStream inputStream2, ProgressListener progressListener, int n) {
        super(inputStream2);
        if (inputStream2 == null || progressListener == null) {
            throw new IllegalArgumentException();
        }
        this.notifyThresHold = n;
        this.listener = progressListener;
    }

    protected void onFirstRead() {
    }

    protected void onEOF() {
    }

    protected void onClose() {
        this.eof();
    }

    protected void onReset() {
    }

    protected void onNotifyBytesRead() {
    }

    private void onBytesRead(int n) {
        this.unnotifiedByteCount += n;
        if (this.unnotifiedByteCount >= this.notifyThresHold) {
            this.onNotifyBytesRead();
            this.notifiedByteCount += (long)this.unnotifiedByteCount;
            this.unnotifiedByteCount = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int n;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((n = super.read()) == -1) {
            this.eof();
        } else {
            this.onBytesRead(1);
        }
        return n;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.onReset();
        this.unnotifiedByteCount = 0;
        this.notifiedByteCount = 0L;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((n3 = super.read(byArray, n, n2)) == -1) {
            this.eof();
        } else {
            this.onBytesRead(n3);
        }
        return n3;
    }

    private void eof() {
        if (this.doneEOF) {
            return;
        }
        this.onEOF();
        this.unnotifiedByteCount = 0;
        this.doneEOF = true;
    }

    public final InputStream getWrappedInputStream() {
        return this.in;
    }

    protected final int getUnnotifiedByteCount() {
        return this.unnotifiedByteCount;
    }

    protected final long getNotifiedByteCount() {
        return this.notifiedByteCount;
    }

    @Override
    public void close() throws IOException {
        this.onClose();
        super.close();
    }

    public final ProgressListener getListener() {
        return this.listener;
    }
}

