/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class WatermarkTemplateDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        WatermarkTemplateDemo.describeMediaTemplates(cOSClient);
    }

    public static void createMediaTemplate1(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTag("Watermark");
        mediaTemplateRequest.setName("mark-watermark-01");
        MediaWatermark mediaWatermark = mediaTemplateRequest.getWatermark();
        mediaWatermark.setType("Text");
        mediaWatermark.setLocMode("Absolute");
        mediaWatermark.setDx("128");
        mediaWatermark.setDy("128");
        mediaWatermark.setPos("TopRight");
        mediaWatermark.setStartTime("0");
        mediaWatermark.setEndTime("100.5");
        MediaWaterMarkText mediaWaterMarkText = mediaWatermark.getText();
        mediaWaterMarkText.setText("\u6c34\u5370\u5185\u5bb9");
        mediaWaterMarkText.setFontSize("30");
        mediaWaterMarkText.setFontType("simfang.ttf");
        mediaWaterMarkText.setFontColor("0x112233");
        mediaWaterMarkText.setTransparency("30");
        MediaTemplateResponse mediaTemplateResponse = cOSClient.createMediaTemplate(mediaTemplateRequest);
        System.out.println(mediaTemplateResponse);
    }

    public static void createMediaTemplate2(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTag("Watermark");
        mediaTemplateRequest.setName("mark-test6");
        MediaWatermark mediaWatermark = mediaTemplateRequest.getWatermark();
        mediaWatermark.setType("Image");
        mediaWatermark.setLocMode("Absolute");
        mediaWatermark.setDx("128");
        mediaWatermark.setDy("128");
        mediaWatermark.setPos("TopRight");
        mediaWatermark.setStartTime("0");
        mediaWatermark.setEndTime("100.5");
        MediaWaterMarkImage mediaWaterMarkImage = mediaWatermark.getImage();
        mediaWaterMarkImage.setUrl("http://DemoBucket-123456789.cos.ap-chongqing.myqcloud.com/1.png");
        mediaWaterMarkImage.setMode("Proportion");
        mediaWaterMarkImage.setWidth("10");
        mediaWaterMarkImage.setHeight("10");
        mediaWaterMarkImage.setTransparency("30");
        MediaTemplateResponse mediaTemplateResponse = cOSClient.createMediaTemplate(mediaTemplateRequest);
        System.out.println(mediaTemplateResponse);
    }

    public static void deleteMediaTemplate(COSClient cOSClient) {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTemplateId("t1c2da66ede73c423bae95d885f7a******");
        Boolean bl = cOSClient.deleteMediaTemplate(mediaTemplateRequest);
        System.out.println(bl);
    }

    public static void describeMediaTemplates(COSClient cOSClient) {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        MediaListTemplateResponse mediaListTemplateResponse = cOSClient.describeMediaTemplates(mediaTemplateRequest);
        List<MediaTemplateObject> list = mediaListTemplateResponse.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : list) {
            System.out.println(mediaTemplateObject);
        }
    }

    public static void updateMediaTemplate(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTemplateId("t1be67e35b0d3b46168cf125f56e*****");
        mediaTemplateRequest.setTag("Watermark");
        mediaTemplateRequest.setName("mark-test-watermark-01");
        MediaWatermark mediaWatermark = mediaTemplateRequest.getWatermark();
        mediaWatermark.setType("Text");
        mediaWatermark.setLocMode("Absolute");
        mediaWatermark.setDx("128");
        mediaWatermark.setDy("128");
        mediaWatermark.setPos("TopRight");
        mediaWatermark.setStartTime("0");
        mediaWatermark.setEndTime("100.5");
        MediaWaterMarkText mediaWaterMarkText = mediaWatermark.getText();
        mediaWaterMarkText.setText("\u4fee\u6539\u6c34\u5370\u5185\u5bb9");
        mediaWaterMarkText.setFontSize("30");
        mediaWaterMarkText.setFontType("simfang.ttf");
        mediaWaterMarkText.setFontColor("0x112233");
        mediaWaterMarkText.setTransparency("30");
        Boolean bl = cOSClient.updateMediaTemplate(mediaTemplateRequest);
        System.out.println(bl);
    }
}

