/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class JobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        JobDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setTag("Transcode");
        mediaJobsRequest.getInput().setObject("1.mp4");
        mediaJobsRequest.getOperation().setTemplateId("t0e09a9456d4124542b1f0e44d501*****");
        mediaJobsRequest.getOperation().getOutput().setBucket("DemoBucket-123456789");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("2.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void createMediaJobs2(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setTag("Transcode");
        mediaJobsRequest.getInput().setObject("1.mp4");
        MediaTranscodeObject mediaTranscodeObject = mediaJobsRequest.getOperation().getTranscode();
        MediaContainerObject mediaContainerObject = mediaTranscodeObject.getContainer();
        mediaContainerObject.setFormat("mp4");
        MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
        mediaTranscodeVideoObject.setCodec("H.264");
        mediaTranscodeVideoObject.setProfile("high");
        mediaTranscodeVideoObject.setBitrate("1000");
        mediaTranscodeVideoObject.setWidth("1280");
        mediaTranscodeVideoObject.setFps("30");
        mediaTranscodeVideoObject.setPreset("medium");
        mediaTranscodeVideoObject.setBufSize("0");
        mediaTranscodeVideoObject.setMaxrate("50000");
        MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("4");
        MediaTimeIntervalObject mediaTimeIntervalObject = mediaTranscodeObject.getTimeInterval();
        mediaTimeIntervalObject.setStart("0");
        mediaTimeIntervalObject.setDuration("60");
        MediaTransConfigObject mediaTransConfigObject = mediaTranscodeObject.getTransConfig();
        mediaJobsRequest.getOperation().getOutput().setBucket("DemoBucket-123456789");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("demo1.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getOperation().getTranscode());
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setJobId("j2b27107ee3ad11ebbf6d73cb5317****");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getOperation().getTranscode());
    }

    public static void describeMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        mediaJobsRequest.setTag("Transcode");
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject.getOperation().getTranscode());
        }
    }

    public static void cancelMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean bl = cOSClient.cancelMediaJob(mediaJobsRequest);
        System.out.println(bl);
    }
}

