/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.model.ciModel.common.ImageProcessRequest;
import com.qcloud.cos.model.ciModel.persistence.CIObject;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedList;

public class ImagePersistenceDemo {
    public static void persistenceImage(COSClient cOSClient) {
        String string = "examplebucket-1250000000";
        String string2 = "test.jpg";
        File file = new File("E://test.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("test-1.jpg");
        rule.setRule("imageMogr2/rotate/90");
        linkedList.add(rule);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(string);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        linkedList.add(rule2);
        picOperations.setRules(linkedList);
        putObjectRequest.setPicOperations(picOperations);
        try {
            PutObjectResult putObjectResult = cOSClient.putObject(putObjectRequest);
            CIUploadResult cIUploadResult = putObjectResult.getCiUploadResult();
            System.out.println(putObjectResult.getRequestId());
            System.out.println(cIUploadResult.getOriginalInfo().getEtag());
            for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
                System.out.println(cIObject.getLocation());
                System.out.println(cIObject.getEtag());
            }
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
    }

    public static void persistenceImageWithMultipart(COSClient cOSClient) throws FileNotFoundException {
        String string = "examplebucket-1250000000";
        String string2 = "test.jpg";
        File file = new File("E://test.jpg");
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(string, string2);
        InitiateMultipartUploadResult initiateMultipartUploadResult = cOSClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        String string3 = initiateMultipartUploadResult.getUploadId();
        LinkedList<PartETag> linkedList = new LinkedList<PartETag>();
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(string);
        uploadPartRequest.setKey(string2);
        uploadPartRequest.setUploadId(string3);
        uploadPartRequest.setInputStream(new FileInputStream(file));
        uploadPartRequest.setPartSize(file.length());
        uploadPartRequest.setPartNumber(1);
        UploadPartResult uploadPartResult = cOSClient.uploadPart(uploadPartRequest);
        PartETag partETag = uploadPartResult.getPartETag();
        linkedList.add(partETag);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList2 = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("test-1.jpg");
        rule.setRule("imageMogr2/rotate/90");
        linkedList2.add(rule);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(string);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        linkedList2.add(rule2);
        picOperations.setRules(linkedList2);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(string, string2, string3, linkedList);
        completeMultipartUploadRequest.setPicOperations(picOperations);
        CompleteMultipartUploadResult completeMultipartUploadResult = cOSClient.completeMultipartUpload(completeMultipartUploadRequest);
        CIUploadResult cIUploadResult = completeMultipartUploadResult.getCiUploadResult();
        System.out.println(completeMultipartUploadResult.getRequestId());
        System.out.println(cIUploadResult.getOriginalInfo().getEtag());
        for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
            System.out.println(cIObject.getLocation());
            System.out.println(cIObject.getEtag());
        }
    }

    public static void persistenceImageWithTransferManager(TransferManager transferManager) throws InterruptedException {
        String string = "examplebucket-1250000000";
        String string2 = "test.jpg";
        File file = new File("E://test.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("test-1.jpg");
        rule.setRule("imageMogr2/rotate/90");
        linkedList.add(rule);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(string);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        linkedList.add(rule2);
        picOperations.setRules(linkedList);
        putObjectRequest.setPicOperations(picOperations);
        Upload upload = transferManager.upload(putObjectRequest);
        UploadResult uploadResult = upload.waitForUploadResult();
        CIUploadResult cIUploadResult = uploadResult.getCiUploadResult();
        System.out.println(uploadResult.getRequestId());
        System.out.println(cIUploadResult.getOriginalInfo().getEtag());
        for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
            System.out.println(cIObject.getLocation());
            System.out.println(cIObject.getEtag());
        }
    }

    public static void persistenceImagePost(COSClient cOSClient) {
        String string = "examplebucket-1250000000";
        String string2 = "test.jpg";
        ImageProcessRequest imageProcessRequest = new ImageProcessRequest(string, string2);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> linkedList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule = new PicOperations.Rule();
        rule.setBucket(string);
        rule.setFileId("test-1.jpg");
        rule.setRule("imageMogr2/rotate/90");
        linkedList.add(rule);
        PicOperations.Rule rule2 = new PicOperations.Rule();
        rule2.setBucket(string);
        rule2.setFileId("test-2.jpg");
        rule2.setRule("imageMogr2/rotate/180");
        linkedList.add(rule2);
        picOperations.setRules(linkedList);
        imageProcessRequest.setPicOperations(picOperations);
        try {
            CIUploadResult cIUploadResult = cOSClient.processImage(imageProcessRequest);
            System.out.println(cIUploadResult.getOriginalInfo().getEtag());
            for (CIObject cIObject : cIUploadResult.getProcessResults().getObjectList()) {
                System.out.println(cIObject.getLocation());
                System.out.println(cIObject.getEtag());
            }
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        ImagePersistenceDemo.persistenceImage(cOSClient);
        cOSClient.shutdown();
    }
}

