/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.COSVersionSummary;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListVersionsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.region.Region;
import java.util.List;

public class ListObjectsDemo {
    public static void listObjectsDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(string);
        listObjectsRequest.setPrefix("");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        try {
            objectListing = cOSClient.listObjects(listObjectsRequest);
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        List<String> list = objectListing.getCommonPrefixes();
        List<COSObjectSummary> list2 = objectListing.getObjectSummaries();
        for (COSObjectSummary cOSObjectSummary : list2) {
            String string2 = cOSObjectSummary.getKey();
            String string3 = cOSObjectSummary.getETag();
            long l = cOSObjectSummary.getSize();
            String string4 = cOSObjectSummary.getStorageClass();
            System.out.println("key: " + string2);
        }
        cOSClient.shutdown();
    }

    public static void listAllObjects() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(string);
        listObjectsRequest.setPrefix("");
        listObjectsRequest.setDelimiter("");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        do {
            try {
                objectListing = cOSClient.listObjects(listObjectsRequest);
            }
            catch (CosServiceException cosServiceException) {
                cosServiceException.printStackTrace();
                return;
            }
            catch (CosClientException cosClientException) {
                cosClientException.printStackTrace();
                return;
            }
            List<String> list = objectListing.getCommonPrefixes();
            List<COSObjectSummary> list2 = objectListing.getObjectSummaries();
            for (COSObjectSummary cOSObjectSummary : list2) {
                String string2 = cOSObjectSummary.getKey();
                String string3 = cOSObjectSummary.getETag();
                long l = cOSObjectSummary.getSize();
                String string4 = cOSObjectSummary.getStorageClass();
            }
            String string5 = objectListing.getNextMarker();
            listObjectsRequest.setMarker(string5);
        } while (objectListing.isTruncated());
        cOSClient.shutdown();
    }

    public static void listObjectsVersions() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest();
        listVersionsRequest.setBucketName(string);
        listVersionsRequest.setPrefix("");
        VersionListing versionListing = null;
        do {
            try {
                versionListing = cOSClient.listVersions(listVersionsRequest);
            }
            catch (CosServiceException cosServiceException) {
                cosServiceException.printStackTrace();
                return;
            }
            catch (CosClientException cosClientException) {
                cosClientException.printStackTrace();
                return;
            }
            List<COSVersionSummary> list = versionListing.getVersionSummaries();
            for (COSVersionSummary cOSVersionSummary : list) {
                System.out.println(cOSVersionSummary.getKey() + ":" + cOSVersionSummary.getVersionId());
            }
            String string2 = versionListing.getNextKeyMarker();
            String object2 = versionListing.getNextVersionIdMarker();
            listVersionsRequest.setKeyMarker(string2);
            listVersionsRequest.setVersionIdMarker(object2);
        } while (versionListing.isTruncated());
        cOSClient.shutdown();
    }

    public static void main(String[] stringArray) {
        ListObjectsDemo.listObjectsVersions();
    }
}

