/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.utils.Md5Utils;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CopyFileDemo {
    public static void copySmallFileDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        Region region = new Region("ap-shanghai");
        String string = "srcBucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "destBucket-1251668577";
        String string4 = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        try {
            CopyObjectResult copyObjectResult = cOSClient.copyObject(copyObjectRequest);
            String string5 = copyObjectResult.getCrc64Ecma();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void copyBigFileDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        Region region = new Region("ap-shanghai");
        String string = "srcBucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "destBucket-1251668577";
        String string4 = "ccc/ddd.txt";
        COSClient cOSClient2 = new COSClient(basicCOSCredentials, new ClientConfig(region));
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, cOSClient2, null);
            CopyResult copyResult = copy.waitForCopyResult();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient2.shutdown();
        cOSClient.shutdown();
    }

    public static void copyWithNewMetaDataDemo() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        Region region = new Region("ap-shanghai");
        String string = "srcBucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "destBucket-1251668577";
        String string4 = "ccc/ddd.txt";
        ClientConfig clientConfig2 = new ClientConfig(region);
        COSClient cOSClient2 = new COSClient(basicCOSCredentials, clientConfig2);
        GetObjectRequest getObjectRequest = new GetObjectRequest(string, string2);
        File file = new File("srcFile");
        cOSClient2.getObject(getObjectRequest, file);
        String string5 = "";
        try {
            string5 = Md5Utils.md5Hex(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.addUserMetadata("md5", string5);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        try {
            CopyObjectResult copyObjectResult = cOSClient.copyObject(copyObjectRequest);
            System.out.print(copyObjectResult.getRequestId());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void main(String[] stringArray) {
        CopyFileDemo.copyWithNewMetaDataDemo();
    }
}

