/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.HttpCredentialsFetcher;
import com.qcloud.cos.auth.InstanceProfileCredentials;
import com.qcloud.cos.exception.CosClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCredentialsFetcher
extends HttpCredentialsFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCredentialsFetcher.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public InstanceCredentialsFetcher(CredentialsEndpointProvider credentialsEndpointProvider) {
        super(credentialsEndpointProvider);
    }

    @Override
    public COSCredentials parse(String string) throws CosClientException {
        if (null == string || string.isEmpty()) {
            return null;
        }
        try {
            CAMSecurityCredentials cAMSecurityCredentials = mapper.readValue(string, CAMSecurityCredentials.class);
            if (null == cAMSecurityCredentials) {
                return null;
            }
            return new InstanceProfileCredentials(cAMSecurityCredentials.tmpSecretId, cAMSecurityCredentials.tmpSecretKey, cAMSecurityCredentials.token, cAMSecurityCredentials.expiredTime);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOG.error("Parse the instance credentials response failed.", jsonProcessingException);
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
    }

    private static class CAMSecurityCredentials {
        public String tmpSecretId;
        public String tmpSecretKey;
        public String token;
        public long expiredTime;
        public String expiration;
        public String code;

        private CAMSecurityCredentials() {
        }
    }
}

