/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSSessionCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacUtils;

public class COSSigner {
    private static Set<String> needSignedHeaderSet = new HashSet<String>();
    private Boolean isCIWorkflowRequest = false;
    private int localTimeDelta = 0;

    private boolean isAnonymous(COSCredentials cOSCredentials) {
        return cOSCredentials instanceof AnonymousCOSCredentials;
    }

    public <X extends CosServiceRequest> void sign(CosHttpRequest<X> cosHttpRequest, COSCredentials cOSCredentials, Date date) {
        if (this.isAnonymous(cOSCredentials)) {
            return;
        }
        String string = this.buildAuthorizationStr(cosHttpRequest.getHttpMethod(), cosHttpRequest.getResourcePath(), cosHttpRequest.getHeaders(), cosHttpRequest.getParameters(), cOSCredentials, date, true);
        cosHttpRequest.addHeader("Authorization", string);
        if (cOSCredentials instanceof COSSessionCredentials) {
            cosHttpRequest.addHeader("x-cos-security-token", ((COSSessionCredentials)cOSCredentials).getSessionToken());
        }
    }

    public String buildPostObjectSignature(String string, String string2, String string3) {
        String string4 = HmacUtils.hmacSha1Hex(string, string2);
        String string5 = DigestUtils.sha1Hex(string3);
        return HmacUtils.hmacSha1Hex(string4, string5);
    }

    public String buildAuthorizationStr(HttpMethodName httpMethodName, String string, COSCredentials cOSCredentials, Date date) {
        Date date2 = new Date();
        return this.buildAuthorizationStr(httpMethodName, string, new HashMap<String, String>(), new HashMap<String, String>(), cOSCredentials, date2, date, true);
    }

    public String buildAuthorizationStr(HttpMethodName httpMethodName, String string, Map<String, String> map, Map<String, String> map2, COSCredentials cOSCredentials, Date date) {
        Date date2 = new Date();
        return this.buildAuthorizationStr(httpMethodName, string, map, map2, cOSCredentials, date2, date, true);
    }

    public String buildAuthorizationStr(HttpMethodName httpMethodName, String string, Map<String, String> map, Map<String, String> map2, COSCredentials cOSCredentials, Date date, Boolean bl) {
        Date date2 = new Date();
        return this.buildAuthorizationStr(httpMethodName, string, map, map2, cOSCredentials, date2, date, bl);
    }

    public String buildAuthorizationStr(HttpMethodName httpMethodName, String string, Map<String, String> map, Map<String, String> map2, COSCredentials cOSCredentials, Date date, Date date2, Boolean bl) {
        String string2;
        if (this.isAnonymous(cOSCredentials)) {
            return null;
        }
        if (this.isCIWorkflowRequest.booleanValue()) {
            string = string.split("\\?")[0];
        }
        Map<String, String> map3 = this.buildSignHeaders(map, bl);
        TreeMap<String, String> treeMap = this.buildEncodeSortedMemberMap(map3);
        TreeMap<String, String> treeMap2 = this.buildEncodeSortedMemberMap(map2);
        String string3 = this.buildSignMemberStr(treeMap);
        String string4 = this.buildSignMemberStr(treeMap2);
        String string5 = string2 = this.buildTimeStr(date, date2);
        String string6 = HmacUtils.hmacSha1Hex(cOSCredentials.getCOSSecretKey(), string5);
        String string7 = httpMethodName.toString().toLowerCase();
        String string8 = string;
        String string9 = this.formatMapToStr(treeMap2);
        String string10 = this.formatMapToStr(treeMap);
        String string11 = string7 + "\n" + string8 + "\n" + string9 + "\n" + string10 + "\n";
        String string12 = DigestUtils.sha1Hex(string11);
        String string13 = "sha1" + "\n" + string2 + "\n" + string12 + "\n";
        String string14 = HmacUtils.hmacSha1Hex(string6, string13);
        String string15 = "q-sign-algorithm" + "=" + "sha1" + "&" + "q-ak" + "=" + cOSCredentials.getCOSAccessKeyId() + "&" + "q-sign-time" + "=" + string2 + "&" + "q-key-time" + "=" + string5 + "&" + "q-header-list" + "=" + string3 + "&" + "q-url-param-list" + "=" + string4 + "&" + "q-signature" + "=" + string14;
        return string15;
    }

    public boolean needSignedHeader(String string) {
        return needSignedHeaderSet.contains(string) || string.startsWith("x-cos-");
    }

    private Map<String, String> buildSignHeaders(Map<String, String> map, Boolean bl) {
        Boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey().toLowerCase();
            if (string.equals("host")) {
                bl2 = true;
            }
            if (!this.needSignedHeader(string)) continue;
            String string2 = entry.getValue();
            hashMap.put(string, string2);
        }
        if (!bl2.booleanValue() && bl.booleanValue()) {
            String string = String.format("buildAuthorization missing header: host. %s", map);
            throw new CosClientException(string);
        }
        return hashMap;
    }

    private TreeMap<String, String> buildEncodeSortedMemberMap(Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            String string = UrlEncoderUtils.encode(entry.getKey().trim()).toLowerCase();
            String string2 = "";
            if (entry.getValue() != null) {
                string2 = entry.getValue().trim();
            }
            String string3 = UrlEncoderUtils.encode(string2);
            treeMap.put(string, string3);
        }
        return treeMap;
    }

    private String buildSignMemberStr(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string : map.keySet()) {
            if (!bl) {
                bl = true;
            } else {
                stringBuilder.append(";");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String formatMapToStr(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!bl) {
                bl = true;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(string).append("=").append(string2);
        }
        return stringBuilder.toString();
    }

    private String buildTimeStr(Date date, Date date2) {
        StringBuilder stringBuilder = new StringBuilder();
        long l = date.getTime() / 1000L + (long)this.localTimeDelta;
        long l2 = date2.getTime() / 1000L + (long)this.localTimeDelta;
        stringBuilder.append(l).append(";").append(l2);
        return stringBuilder.toString();
    }

    public static Set<String> getNeedSignedHeaderSet() {
        return needSignedHeaderSet;
    }

    public static void setNeedSignedHeaderSet(Set<String> set) {
        needSignedHeaderSet = set;
    }

    public void setCIWorkflowRequest(Boolean bl) {
        this.isCIWorkflowRequest = bl;
    }

    public int getLocalTimeDelta() {
        return this.localTimeDelta;
    }

    public void setLocalTimeDelta(int n) {
        this.localTimeDelta = n;
    }

    static {
        needSignedHeaderSet.add("cache-control");
        needSignedHeaderSet.add("content-disposition");
        needSignedHeaderSet.add("content-encoding");
        needSignedHeaderSet.add("content-length");
        needSignedHeaderSet.add("content-md5");
        needSignedHeaderSet.add("content-type");
        needSignedHeaderSet.add("expect");
        needSignedHeaderSet.add("expires");
        needSignedHeaderSet.add("host");
        needSignedHeaderSet.add("if-match");
        needSignedHeaderSet.add("if-modified-since");
        needSignedHeaderSet.add("if-none-match");
        needSignedHeaderSet.add("if-unmodified-since");
        needSignedHeaderSet.add("origin");
        needSignedHeaderSet.add("range");
        needSignedHeaderSet.add("transfer-encoding");
    }
}

