/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.endpoint.DefaultEndpointResolver;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.endpoint.EndpointResolver;
import com.qcloud.cos.endpoint.RegionEndpointBuilder;
import com.qcloud.cos.endpoint.SuffixEndpointBuilder;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.retry.PredefinedBackoffStrategies;
import com.qcloud.cos.retry.PredefinedRetryPolicies;
import com.qcloud.cos.retry.RetryPolicy;
import com.qcloud.cos.utils.VersionInfoUtils;

public class ClientConfig {
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = -1;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final int DEFAULT_MAX_CONNECTIONS_COUNT = 1024;
    private static final int DEFAULT_IDLE_CONNECTION_ALIVE = 60000;
    private static final long DEFAULT_SIGN_EXPIRED = 3600L;
    private static final String DEFAULT_USER_AGENT = VersionInfoUtils.getUserAgent();
    private static final int DEFAULT_READ_LIMIT = 262145;
    private static final int DEFAULT_RETRY_TIMES = 3;
    private int maxErrorRetry = 3;
    private static final RetryPolicy DEFAULT_RETRY_POLICY = PredefinedRetryPolicies.DEFAULT;
    public static final BackoffStrategy DEFAULT_BACKOFF_STRATEGY = PredefinedBackoffStrategies.DEFAULT;
    private Region region;
    private HttpProtocol httpProtocol = HttpProtocol.https;
    private String endPointSuffix = null;
    private EndpointBuilder endpointBuilder = null;
    private EndpointResolver endpointResolver = new DefaultEndpointResolver();
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private BackoffStrategy backoffStrategy = DEFAULT_BACKOFF_STRATEGY;
    private String httpProxyIp = null;
    private int httpProxyPort = 0;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean useBasicAuth = false;
    private long signExpired = 3600L;
    private int connectionRequestTimeout = -1;
    private int connectionTimeout = 30000;
    private int socketTimeout = 30000;
    private int maxConnectionsCount = 1024;
    private int idleConnectionAlive = 60000;
    private String userAgent = DEFAULT_USER_AGENT;
    private int readLimit = 262145;
    private COSSigner cosSigner = new COSSigner();
    private boolean ciSpecialRequest = false;
    private boolean isDistinguishHost = false;
    private boolean isShortConnection = false;

    public ClientConfig() {
        this.region = null;
        this.endpointBuilder = new RegionEndpointBuilder(this.region);
    }

    public ClientConfig(Region region) {
        this.region = region;
        this.endpointBuilder = new RegionEndpointBuilder(this.region);
    }

    public int getIdleConnectionAlive() {
        return this.idleConnectionAlive;
    }

    public void setIdleConnectionAlive(int n) {
        this.idleConnectionAlive = n;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
        this.endpointBuilder = new RegionEndpointBuilder(this.region);
    }

    public HttpProtocol getHttpProtocol() {
        return this.httpProtocol;
    }

    public void setHttpProtocol(HttpProtocol httpProtocol) {
        this.httpProtocol = httpProtocol;
    }

    public String getHttpProxyIp() {
        return this.httpProxyIp;
    }

    public void setHttpProxyIp(String string) {
        this.httpProxyIp = string;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int n) {
        this.httpProxyPort = n;
    }

    public long getSignExpired() {
        return this.signExpired;
    }

    public void setSignExpired(long l) {
        this.signExpired = l;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int n) {
        this.connectionRequestTimeout = n;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public int getMaxConnectionsCount() {
        return this.maxConnectionsCount;
    }

    public void setMaxConnectionsCount(int n) {
        this.maxConnectionsCount = n;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Deprecated
    public String getEndPointSuffix() {
        return this.endPointSuffix;
    }

    public void setEndPointSuffix(String string) {
        this.endPointSuffix = string;
        this.endpointBuilder = new SuffixEndpointBuilder(string);
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(int n) {
        this.readLimit = n;
    }

    public EndpointBuilder getEndpointBuilder() {
        return this.endpointBuilder;
    }

    public void setEndpointBuilder(EndpointBuilder endpointBuilder) {
        this.endpointBuilder = endpointBuilder;
    }

    public EndpointResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public void setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setUseBasicAuth(boolean bl) {
        this.useBasicAuth = bl;
    }

    public boolean useBasicAuth() {
        return this.useBasicAuth;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int n) {
        this.maxErrorRetry = n;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public COSSigner getCosSigner() {
        return this.cosSigner;
    }

    public void setCosSigner(COSSigner cOSSigner) {
        this.cosSigner = cOSSigner;
    }

    public boolean getCiSpecialRequest() {
        return this.ciSpecialRequest;
    }

    public void setCiSpecialRequest(boolean bl) {
        this.ciSpecialRequest = bl;
    }

    public void setIsDistinguishHost(boolean bl) {
        this.isDistinguishHost = bl;
    }

    public boolean getIsDistinguishHost() {
        return this.isDistinguishHost;
    }

    public void setShortConnection() {
        this.isShortConnection = true;
    }

    public boolean isShortConnection() {
        return this.isShortConnection;
    }
}

