/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field field) {
            return field.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field field) {
            return 2.upperCaseFirstLetter(field.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field field) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(field.getName(), " "));
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field field) {
            return 4.separateCamelCase(field.getName(), "_").toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field field) {
            return 5.separateCamelCase(field.getName(), "-").toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public String translateName(Field field) {
            return 6.separateCamelCase(field.getName(), ".").toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && stringBuilder.length() != 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String string) {
        int n;
        int n2 = string.length() - 1;
        for (n = 0; !Character.isLetter(string.charAt(n)) && n < n2; ++n) {
        }
        char c = string.charAt(n);
        if (Character.isUpperCase(c)) {
            return string;
        }
        char c2 = Character.toUpperCase(c);
        if (n == 0) {
            return c2 + string.substring(1);
        }
        return string.substring(0, n) + c2 + string.substring(n + 1);
    }
}

