/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Uninterruptibles {
    @J2ktIncompatible
    @GwtIncompatible
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        boolean bl = false;
        while (true) {
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, Duration duration) {
        return Uninterruptibles.awaitUninterruptibly(countDownLatch, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = countDownLatch.await(l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitUninterruptibly(Condition condition, Duration duration) {
        return Uninterruptibles.awaitUninterruptibly(condition, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitUninterruptibly(Condition condition, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = condition.await(l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void joinUninterruptibly(Thread thread2) {
        boolean bl = false;
        while (true) {
            try {
                thread2.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void joinUninterruptibly(Thread thread2, Duration duration) {
        Uninterruptibles.joinUninterruptibly(thread2, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void joinUninterruptibly(Thread thread2, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull(thread2);
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.timedJoin(thread2, l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V> V getUninterruptibly(Future<V> future, Duration duration) throws ExecutionException, TimeoutException {
        return Uninterruptibles.getUninterruptibly(future, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V> V getUninterruptibly(Future<V> future, long l, TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                V v;
                try {
                    v = future.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                return v;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E> E takeUninterruptibly(BlockingQueue<E> blockingQueue) {
        boolean bl = false;
        while (true) {
            try {
                E e = blockingQueue.take();
                return e;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E> void putUninterruptibly(BlockingQueue<E> blockingQueue, E e) {
        boolean bl = false;
        while (true) {
            try {
                blockingQueue.put(e);
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void sleepUninterruptibly(Duration duration) {
        Uninterruptibles.sleepUninterruptibly(Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void sleepUninterruptibly(long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, Duration duration) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, long l, TimeUnit timeUnit) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, 1, l, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, int n, Duration duration) {
        return Uninterruptibles.tryAcquireUninterruptibly(semaphore, n, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryAcquireUninterruptibly(Semaphore semaphore, int n, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = semaphore.tryAcquire(n, l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryLockUninterruptibly(Lock lock, Duration duration) {
        return Uninterruptibles.tryLockUninterruptibly(lock, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean tryLockUninterruptibly(Lock lock, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = lock.tryLock(l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void awaitTerminationUninterruptibly(ExecutorService executorService) {
        Verify.verify(Uninterruptibles.awaitTerminationUninterruptibly(executorService, Long.MAX_VALUE, TimeUnit.NANOSECONDS));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitTerminationUninterruptibly(ExecutorService executorService, Duration duration) {
        return Uninterruptibles.awaitTerminationUninterruptibly(executorService, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static boolean awaitTerminationUninterruptibly(ExecutorService executorService, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = executorService.awaitTermination(l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Uninterruptibles() {
    }
}

