/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ForwardingCondition;
import com.google.common.util.concurrent.ForwardingLock;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class Striped<L> {
    private static final int LARGE_LAZY_CUTOFF = 1024;
    private static final int ALL_SET = -1;

    private Striped() {
    }

    public abstract L get(Object var1);

    public abstract L getAt(int var1);

    abstract int indexFor(Object var1);

    public abstract int size();

    public Iterable<L> bulkGet(Iterable<? extends Object> iterable) {
        int n;
        ArrayList<? extends Object> arrayList = Lists.newArrayList(iterable);
        if (arrayList.isEmpty()) {
            return ImmutableList.of();
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = this.indexFor(arrayList.get(n));
        }
        Arrays.sort(nArray);
        n = nArray[0];
        arrayList.set(0, this.getAt(n));
        for (int i = 1; i < arrayList.size(); ++i) {
            int n2 = nArray[i];
            if (n2 == n) {
                arrayList.set(i, arrayList.get(i - 1));
                continue;
            }
            arrayList.set(i, this.getAt(n2));
            n = n2;
        }
        ArrayList<? extends Object> arrayList2 = arrayList;
        return Collections.unmodifiableList(arrayList2);
    }

    static <L> Striped<L> custom(int n, Supplier<L> supplier) {
        return new CompactStriped(n, supplier);
    }

    public static Striped<Lock> lock(int n) {
        return Striped.custom(n, PaddedLock::new);
    }

    public static Striped<Lock> lazyWeakLock(int n) {
        return Striped.lazy(n, () -> new ReentrantLock(false));
    }

    private static <L> Striped<L> lazy(int n, Supplier<L> supplier) {
        return n < 1024 ? new SmallLazyStriped<L>(n, supplier) : new LargeLazyStriped<L>(n, supplier);
    }

    public static Striped<Semaphore> semaphore(int n, int n2) {
        return Striped.custom(n, () -> new PaddedSemaphore(n2));
    }

    public static Striped<Semaphore> lazyWeakSemaphore(int n, int n2) {
        return Striped.lazy(n, () -> new Semaphore(n2, false));
    }

    public static Striped<ReadWriteLock> readWriteLock(int n) {
        return Striped.custom(n, ReentrantReadWriteLock::new);
    }

    public static Striped<ReadWriteLock> lazyWeakReadWriteLock(int n) {
        return Striped.lazy(n, WeakSafeReadWriteLock::new);
    }

    private static int ceilToPowerOfTwo(int n) {
        return 1 << IntMath.log2(n, RoundingMode.CEILING);
    }

    private static int smear(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static class PaddedSemaphore
    extends Semaphore {
        long unused1;
        long unused2;
        long unused3;

        PaddedSemaphore(int n) {
            super(n, false);
        }
    }

    private static class PaddedLock
    extends ReentrantLock {
        long unused1;
        long unused2;
        long unused3;

        PaddedLock() {
            super(false);
        }
    }

    @VisibleForTesting
    static class LargeLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final ConcurrentMap<Integer, L> locks;
        final Supplier<L> supplier;
        final int size;

        LargeLazyStriped(int n, Supplier<L> supplier) {
            super(n);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.supplier = supplier;
            this.locks = new MapMaker().weakValues().makeMap();
        }

        @Override
        public L getAt(int n) {
            Object object;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(n, this.size());
            }
            if ((object = this.locks.get(n)) != null) {
                return (L)object;
            }
            L l = this.supplier.get();
            object = this.locks.putIfAbsent(n, l);
            return (L)MoreObjects.firstNonNull(object, l);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @VisibleForTesting
    static class SmallLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final AtomicReferenceArray<@Nullable ArrayReference<? extends L>> locks;
        final Supplier<L> supplier;
        final int size;
        final ReferenceQueue<L> queue = new ReferenceQueue();

        SmallLazyStriped(int n, Supplier<L> supplier) {
            super(n);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.locks = new AtomicReferenceArray(this.size);
            this.supplier = supplier;
        }

        @Override
        public L getAt(int n) {
            ArrayReference<? extends L> arrayReference;
            L l;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(n, this.size());
            }
            L l2 = l = (arrayReference = this.locks.get(n)) == null ? null : (L)arrayReference.get();
            if (l != null) {
                return l;
            }
            L l3 = this.supplier.get();
            ArrayReference<L> arrayReference2 = new ArrayReference<L>(l3, n, this.queue);
            while (!this.locks.compareAndSet(n, arrayReference, arrayReference2)) {
                arrayReference = this.locks.get(n);
                l = arrayReference == null ? null : (L)arrayReference.get();
                if (l == null) continue;
                return l;
            }
            this.drainQueue();
            return l3;
        }

        private void drainQueue() {
            Reference<L> reference;
            while ((reference = this.queue.poll()) != null) {
                ArrayReference arrayReference = (ArrayReference)reference;
                this.locks.compareAndSet(arrayReference.index, arrayReference, null);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        private static final class ArrayReference<L>
        extends WeakReference<L> {
            final int index;

            ArrayReference(L l, int n, ReferenceQueue<L> referenceQueue) {
                super(l, referenceQueue);
                this.index = n;
            }
        }
    }

    private static class CompactStriped<L>
    extends PowerOfTwoStriped<L> {
        private final Object[] array;

        private CompactStriped(int n, Supplier<L> supplier) {
            super(n);
            Preconditions.checkArgument(n <= 0x40000000, "Stripes must be <= 2^30)");
            this.array = new Object[this.mask + 1];
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = supplier.get();
            }
        }

        @Override
        public L getAt(int n) {
            return (L)this.array[n];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    private static abstract class PowerOfTwoStriped<L>
    extends Striped<L> {
        final int mask;

        PowerOfTwoStriped(int n) {
            Preconditions.checkArgument(n > 0, "Stripes must be positive");
            this.mask = n > 0x40000000 ? -1 : Striped.ceilToPowerOfTwo(n) - 1;
        }

        @Override
        final int indexFor(Object object) {
            int n = Striped.smear(object.hashCode());
            return n & this.mask;
        }

        @Override
        public final L get(Object object) {
            return this.getAt(this.indexFor(object));
        }
    }

    private static final class WeakSafeCondition
    extends ForwardingCondition {
        private final Condition delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeCondition(Condition condition, WeakSafeReadWriteLock weakSafeReadWriteLock) {
            this.delegate = condition;
            this.strongReference = weakSafeReadWriteLock;
        }

        @Override
        Condition delegate() {
            return this.delegate;
        }
    }

    private static final class WeakSafeLock
    extends ForwardingLock {
        private final Lock delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeLock(Lock lock, WeakSafeReadWriteLock weakSafeReadWriteLock) {
            this.delegate = lock;
            this.strongReference = weakSafeReadWriteLock;
        }

        @Override
        Lock delegate() {
            return this.delegate;
        }

        @Override
        public Condition newCondition() {
            return new WeakSafeCondition(this.delegate.newCondition(), this.strongReference);
        }
    }

    private static final class WeakSafeReadWriteLock
    implements ReadWriteLock {
        private final ReadWriteLock delegate = new ReentrantReadWriteLock();

        WeakSafeReadWriteLock() {
        }

        @Override
        public Lock readLock() {
            return new WeakSafeLock(this.delegate.readLock(), this);
        }

        @Override
        public Lock writeLock() {
            return new WeakSafeLock(this.delegate.writeLock(), this);
        }
    }
}

