/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class LazyLogger {
    private final String loggerName;
    private volatile @Nullable Logger logger;

    LazyLogger(Class<?> clazz) {
        this.loggerName = clazz.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger get() {
        Logger logger = this.logger;
        if (logger != null) {
            return logger;
        }
        LazyLogger lazyLogger = this;
        synchronized (lazyLogger) {
            logger = this.logger;
            if (logger != null) {
                return logger;
            }
            this.logger = Logger.getLogger(this.loggerName);
            return this.logger;
        }
    }
}

