/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.InterruptibleTask;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CombinedFuture<V>
extends AggregateFuture<Object, V> {
    @CheckForNull
    @LazyInit
    private CombinedFutureInterruptibleTask<?> task;

    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> immutableCollection, boolean bl, Executor executor, AsyncCallable<V> asyncCallable) {
        super(immutableCollection, bl, false);
        this.task = new AsyncCallableInterruptibleTask(asyncCallable, executor);
        this.init();
    }

    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> immutableCollection, boolean bl, Executor executor, Callable<V> callable) {
        super(immutableCollection, bl, false);
        this.task = new CallableInterruptibleTask(callable, executor);
        this.init();
    }

    @Override
    void collectOneValue(int n, @CheckForNull Object object) {
    }

    @Override
    void handleAllCompleted() {
        CombinedFutureInterruptibleTask<?> combinedFutureInterruptibleTask = this.task;
        if (combinedFutureInterruptibleTask != null) {
            combinedFutureInterruptibleTask.execute();
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason releaseResourcesReason) {
        super.releaseResources(releaseResourcesReason);
        if (releaseResourcesReason == AggregateFuture.ReleaseResourcesReason.OUTPUT_FUTURE_DONE) {
            this.task = null;
        }
    }

    @Override
    protected void interruptTask() {
        CombinedFutureInterruptibleTask<?> combinedFutureInterruptibleTask = this.task;
        if (combinedFutureInterruptibleTask != null) {
            combinedFutureInterruptibleTask.interruptTask();
        }
    }

    private final class CallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<V> {
        private final Callable<V> callable;

        CallableInterruptibleTask(Callable<V> callable, Executor executor) {
            super(executor);
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        @ParametricNullness
        V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        @Override
        void setValue(@ParametricNullness V v) {
            CombinedFuture.this.set(v);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private final class AsyncCallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<ListenableFuture<V>> {
        private final AsyncCallable<V> callable;

        AsyncCallableInterruptibleTask(AsyncCallable<V> asyncCallable, Executor executor) {
            super(executor);
            this.callable = Preconditions.checkNotNull(asyncCallable);
        }

        @Override
        ListenableFuture<V> runInterruptibly() throws Exception {
            ListenableFuture listenableFuture = this.callable.call();
            return Preconditions.checkNotNull(listenableFuture, "AsyncCallable.call returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", this.callable);
        }

        @Override
        void setValue(ListenableFuture<V> listenableFuture) {
            CombinedFuture.this.setFuture(listenableFuture);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private abstract class CombinedFutureInterruptibleTask<T>
    extends InterruptibleTask<T> {
        private final Executor listenerExecutor;

        CombinedFutureInterruptibleTask(Executor executor) {
            this.listenerExecutor = Preconditions.checkNotNull(executor);
        }

        @Override
        final boolean isDone() {
            return CombinedFuture.this.isDone();
        }

        final void execute() {
            try {
                this.listenerExecutor.execute(this);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                CombinedFuture.this.setException(rejectedExecutionException);
            }
        }

        @Override
        final void afterRanInterruptiblySuccess(@ParametricNullness T t2) {
            CombinedFuture.this.task = null;
            this.setValue(t2);
        }

        @Override
        final void afterRanInterruptiblyFailure(Throwable throwable) {
            CombinedFuture.this.task = null;
            if (throwable instanceof ExecutionException) {
                CombinedFuture.this.setException(((ExecutionException)throwable).getCause());
            } else if (throwable instanceof CancellationException) {
                CombinedFuture.this.cancel(false);
            } else {
                CombinedFuture.this.setException(throwable);
            }
        }

        abstract void setValue(@ParametricNullness T var1);
    }
}

