/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Atomics {
    private Atomics() {
    }

    public static <V> AtomicReference<@Nullable V> newReference() {
        return new AtomicReference();
    }

    public static <V> AtomicReference<V> newReference(@ParametricNullness V v) {
        return new AtomicReference<V>(v);
    }

    public static <E> AtomicReferenceArray<@Nullable E> newReferenceArray(int n) {
        return new AtomicReferenceArray(n);
    }

    public static <E> AtomicReferenceArray<E> newReferenceArray(E[] EArray) {
        return new AtomicReferenceArray<E>(EArray);
    }
}

