/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Platform;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractTransformFuture<I, O, F, T>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    @CheckForNull
    @LazyInit
    ListenableFuture<? extends I> inputFuture;
    @CheckForNull
    @LazyInit
    F function;

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> asyncTransformFuture = new AsyncTransformFuture<I, O>(listenableFuture, asyncFunction);
        listenableFuture.addListener(asyncTransformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, asyncTransformFuture));
        return asyncTransformFuture;
    }

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> transformFuture = new TransformFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(transformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, transformFuture));
        return transformFuture;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> listenableFuture, F f) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t2;
        I i;
        ListenableFuture<I> listenableFuture = this.inputFuture;
        F f = this.function;
        if (this.isCancelled() | listenableFuture == null | f == null) {
            return;
        }
        this.inputFuture = null;
        if (listenableFuture.isCancelled()) {
            boolean bl = this.setFuture(listenableFuture);
            return;
        }
        try {
            i = Futures.getDone(listenableFuture);
        }
        catch (CancellationException cancellationException) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException executionException) {
            this.setException(executionException.getCause());
            return;
        }
        catch (Exception exception) {
            this.setException(exception);
            return;
        }
        catch (Error error) {
            this.setException(error);
            return;
        }
        try {
            t2 = this.doTransform(f, i);
        }
        catch (Throwable throwable) {
            Platform.restoreInterruptIfIsInterruptedException(throwable);
            this.setException(throwable);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(t2);
    }

    @ParametricNullness
    @ForOverride
    abstract T doTransform(F var1, @ParametricNullness I var2) throws Exception;

    @ForOverride
    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<? extends I> listenableFuture = this.inputFuture;
        F f = this.function;
        String string = super.pendingToString();
        String string2 = "";
        if (listenableFuture != null) {
            string2 = "inputFuture=[" + listenableFuture + "], ";
        }
        if (f != null) {
            return string2 + "function=[" + f + "]";
        }
        if (string != null) {
            return string2 + string;
        }
        return null;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> listenableFuture, Function<? super I, ? extends O> function) {
            super(listenableFuture, function);
        }

        @Override
        @ParametricNullness
        O doTransform(Function<? super I, ? extends O> function, @ParametricNullness I i) {
            return function.apply(i);
        }

        @Override
        void setResult(@ParametricNullness O o) {
            this.set(o);
        }
    }

    private static final class AsyncTransformFuture<I, O>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        AsyncTransformFuture(ListenableFuture<? extends I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
            super(listenableFuture, asyncFunction);
        }

        @Override
        ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> asyncFunction, @ParametricNullness I i) throws Exception {
            ListenableFuture<? extends O> listenableFuture = asyncFunction.apply(i);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", asyncFunction);
            return listenableFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends O> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }
}

